package com.cusc.nirvana.user.auth.common.constants;

/**
 * Description: 用户类型
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum UserTypeEnum {

    EIAM(1, "B端用户"),
    CIAM(2, "C端用户");

    private int code;
    private String name;

    UserTypeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static UserTypeEnum getEnumByCode(int code) {
        for (UserTypeEnum sys : UserTypeEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
