package com.cusc.nirvana.user.auth.common.constants;

/**
 * Description: 验证码类型
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum CaptchaTypeEnum {

    TYPE_DEFAULT(1, "字母数字混合"),
    TYPE_ONLY_NUMBER(2, "纯数字"),
    TYPE_ONLY_CHAR(3, "纯字母"),
    TYPE_ONLY_UPPER(4, "纯大写字母"),
    TYPE_ONLY_LOWER(5, "纯小写字母"),
    TYPE_NUM_AND_UPPER(6, "数字大写字母");

    private int code;
    private String name;

    CaptchaTypeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static CaptchaTypeEnum getEnumByCode(int code) {
        for (CaptchaTypeEnum sys : CaptchaTypeEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
