package com.cusc.nirvana.user.eiam.constants;

/**
 * Description: 租户业务场景枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum OrganSceneEnum {

    RNR("1", "实名组织"),
    COM("2", "流量运营组织");

    private String code;
    private String name;

    OrganSceneEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static OrganSceneEnum getEnumByCode(String code) {
        for (OrganSceneEnum sys : OrganSceneEnum.values()) {
            if (sys.getCode().equals(code)) {
                return sys;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
