package com.cusc.nirvana.user.eiam.dto;

import com.cusc.nirvana.user.eiam.common.BaseIamPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 角色对象
 * </p>
 *
 * @author yuy336
 * @since 2021-10-20
 */
@ApiModel(value = "角色信息", description = "角色信息")
@Data
public class RoleDTO extends BaseIamPageDTO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "角色场景：1 租户角色  2 用户角色")
    private Integer roleScene;

    @ApiModelProperty(value = "角色类型：1 平台管理员、2 租户管理员、3 审计员、4 普通角色")
    private Integer roleType;

    @ApiModelProperty(value = "角色编码")
    private String roleCode;

    @ApiModelProperty(value = "角色名称")
    private String roleName;

    @ApiModelProperty(value = "角色描述")
    private String description;

    @ApiModelProperty(value = "父级角色id")
    private String parentId;

    @ApiModelProperty(value = "应用id")
    private String applicationId;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "状态： 0 禁用 1启用")
    private Integer status;

    @ApiModelProperty(value = "展示顺序，数字越大越靠前")
    private Integer displaySort;

    @ApiModelProperty(value = "租户编号集合")
    private List<String> tenantNoList;

    @ApiModelProperty(value = "角色uuid集合")
    private List<String> uuidList;

    @ApiModelProperty(value = "资源uuid集合")
    private List<String> resourceUuidList;

    @ApiModelProperty(value = "资源名称拼接")
    private String resourceNames;

    @ApiModelProperty(value = "资源uuid")
    private String resourceUuid;

    @ApiModelProperty(value = "资源集合")
    private List<ResourceSimpleDTO> resourceList;

    @ApiModelProperty(value = "岗位id")
    private String positionId;

    @ApiModelProperty(value = "用户id")
    private String userId;
}
