package com.cusc.nirvana.user.ciam.dto;

import com.cusc.nirvana.user.ciam.common.BaseIamDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 终端用户
 * </p>
 *
 * @author yuy336
 * @since 2021-10-14
 */
@ApiModel(value = "UserDTO对象", description = "终端用户")
@Data
public class CiamUserDTO extends BaseIamDTO {

    private static final long serialVersionUID = 1L;

    public CiamUserDTO() {
    }

    public CiamUserDTO(String phoneNum, String tenantNo) {
        this.phoneNum = phoneNum;
        this.tenantNo = tenantNo;
    }

    @ApiModelProperty(value = "手机号码")
    private String phoneNum;

    @ApiModelProperty(value = "状态")
    private Integer status;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "昵称")
    private String nickName;

    @ApiModelProperty(value = "头像")
    private String headPortrait;
}
