/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.common.UserLogOutputJsonSerializeFilter;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTemplateUtils.class);

    public static <T> Response<T> postForResponse(RestTemplate restTemplate, String url, Object request, Class<T> cls, Object ... urlVariables) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("postForResponse url: {},request: {}", (Object)url, (Object)JSON.toJSONString((Object)request, (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]));
        ResponseEntity entity = restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(request), String.class, urlVariables);
        LOGGER.info("postForResponse url: {},response: {},cost: {} ms", new Object[]{url, JSON.toJSONString((Object)entity.getBody(), (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]), System.currentTimeMillis() - startTime});
        Response result = (Response)JSON.parseObject((String)((String)entity.getBody()), (Type)new TypeReference<Response<T>>(new Type[]{cls}){}.getType(), (Feature[])new Feature[0]);
        return result;
    }

    public static <T> Response<T> postEntityForResponse(RestTemplate restTemplate, String url, HttpEntity<?> requestEntity, Class<T> cls, Object ... urlVariables) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("postEntityForResponse url: {},request: {}", (Object)url, (Object)JSON.toJSONString(requestEntity, (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]));
        ResponseEntity entity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, urlVariables);
        LOGGER.info("postEntityForResponse url: {},response: {},cost: {} ms", new Object[]{url, JSON.toJSONString((Object)entity.getBody(), (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]), System.currentTimeMillis() - startTime});
        Response result = (Response)JSON.parseObject((String)((String)entity.getBody()), (Type)new TypeReference<Response<T>>(new Type[]{cls}){}.getType(), (Feature[])new Feature[0]);
        return result;
    }

    public static Response postForResponse(RestTemplate restTemplate, String url, Object request, Object ... urlVariables) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("postForResponse url: {},request: {}", (Object)url, (Object)JSON.toJSONString((Object)request, (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]));
        ResponseEntity entity = restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(request), String.class, urlVariables);
        LOGGER.info("postForResponse url: {},response: {},cost: {} ms", new Object[]{url, JSON.toJSONString((Object)entity.getBody(), (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]), System.currentTimeMillis() - startTime});
        Response result = (Response)JSON.parseObject((String)((String)entity.getBody()), Response.class);
        return result;
    }

    public static <T> Response<PageResult<T>> postForResponsePageResult(RestTemplate restTemplate, String url, Object request, Class<T> cls, Object ... urlVariables) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("postForResponsePageResult url: {},request: {}", (Object)url, (Object)JSON.toJSONString((Object)request, (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]));
        ResponseEntity entity = restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(request), String.class, urlVariables);
        LOGGER.info("postForResponsePageResult url: {},response: {},cost: {} ms", new Object[]{url, JSON.toJSONString((Object)entity.getBody(), (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]), System.currentTimeMillis() - startTime});
        Response result = (Response)JSON.parseObject((String)((String)entity.getBody()), (Type)new TypeReference<Response<PageResult<T>>>(new Type[]{cls}){}.getType(), (Feature[])new Feature[0]);
        return result;
    }

    public static <T> Response<List<T>> postForResponseList(RestTemplate restTemplate, String url, Object request, Class<T> cls, Object ... urlVariables) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("postForResponseList url: {},request: {}", (Object)url, (Object)JSON.toJSONString((Object)request, (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]));
        ResponseEntity entity = restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(request), String.class, urlVariables);
        LOGGER.info("postForResponseList url: {},response: {},cost: {} ms", new Object[]{url, JSON.toJSONString((Object)entity.getBody(), (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]), System.currentTimeMillis() - startTime});
        Response result = (Response)JSON.parseObject((String)((String)entity.getBody()), (Type)new TypeReference<Response<List<T>>>(new Type[]{cls}){}.getType(), (Feature[])new Feature[0]);
        return result;
    }

    public static <T> T getForObject(RestTemplate restTemplate, String url, Class<T> cls) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("getForObject url: {}", (Object)url);
        ResponseEntity entity = restTemplate.getForEntity(url, String.class, new Object[0]);
        LOGGER.info("getForObject url: {},response: {},cost: {} ms", new Object[]{url, JSON.toJSONString((Object)entity.getBody(), (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]), System.currentTimeMillis() - startTime});
        return (T)JSON.parseObject((String)((String)entity.getBody()), cls);
    }

    public static <T> Response<List<T>> getForResponseList(RestTemplate restTemplate, String url, Class<T> cls, Object ... urlVariables) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("getForResponseList url: {},request: {}", (Object)url, (Object)JSON.toJSONString((Object)urlVariables, (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]));
        ResponseEntity entity = restTemplate.exchange(url, HttpMethod.GET, null, String.class, urlVariables);
        LOGGER.info("getForResponseList url: {},response: {},cost: {} ms", new Object[]{url, JSON.toJSONString((Object)entity.getBody(), (SerializeFilter)new UserLogOutputJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]), System.currentTimeMillis() - startTime});
        Response result = (Response)JSON.parseObject((String)((String)entity.getBody()), (Type)new TypeReference<Response<List<T>>>(new Type[]{cls}){}.getType(), (Feature[])new Feature[0]);
        return result;
    }
}

