package com.cusc.nirvana.user.eiam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * Description: 短信发送配置
 * <br />
 * CreateDate 2022-01-27 14:26:28
 *
 * @author yuyi
 **/
@ApiModel(value = "短信发送配置", description = "短信发送配置")
@Data
public class SmsSendConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "短信发送总次数限制（天）")
    private Integer smsTotalLimit;

    @ApiModelProperty(value = "短信发送间隔限制（秒）")
    private Integer smsIntervalLimit;

    @ApiModelProperty(value = "短信签名code")
    private String smsSignatureCode;

    @ApiModelProperty(value = "短信平台key")
    private String smsPlatformKey;

    @ApiModelProperty(value = "短信模板code。描述各场景（登录、忘记密码等）的短信模板")
    private String smsTemplateCode;

    @ApiModelProperty(value = "推送策略Code")
    public String strategyCode;

    @ApiModelProperty(value = "短信发送总次数限制KEY")
    public String totalLimitKey;

    @ApiModelProperty(value = "短信发送间隔限制KEY")
    public String intervalLimitKey;

    @ApiModelProperty(value = "应用id")
    public String appId;

    @ApiModelProperty(value = "租户编号")
    public String tenantNo;

}
