package com.cusc.nirvana.user.eiam.dto;

import com.cusc.nirvana.user.eiam.common.BaseIamDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Description: 角色资源 dto对象
 * <br />
 * CreateDate 2021-11-05 15:09:08
 *
 * @author yuyi
 **/
@ApiModel(value = "角色资源 dto对象", description = "角色资源 dto对象")
@Data
public class RoleResourceDTO extends BaseIamDTO {

    private static final long serialVersionUID = 1L;

    private String roleId;

    private String resourceId;

    @ApiModelProperty(value = "应用id")
    private String applicationId;

    @ApiModelProperty(value = "租户id")
    private String tenantNo;

    @ApiModelProperty(value = "租户编号集合")
    private List<String> tenantNoList;

    @ApiModelProperty(value = "控制查询的数量")
    private Integer size;

    @ApiModelProperty(value = "资源uuid集合")
    private List<String> resourceUuidList;

    @ApiModelProperty(value = "角色id集合")
    private List<String> roleIdList;
}
