package com.cusc.nirvana.user.eiam.dto;

import com.cusc.nirvana.user.eiam.common.BaseIamPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 资源信息传输对象类
 *
 * @author yuy336
 * @since 2022-01-12 15:00:24
 */
@ApiModel(value = "ResourceDTO对象", description = "ResourceDTO对象")
@Data
public class ResourceDTO extends BaseIamPageDTO {

    @ApiModelProperty(value = "资源编码")
    private String resourceCode;

    @ApiModelProperty(value = "资源页面path，定位ui元素使用")
    private String resourceUiPath;

    @ApiModelProperty(value = "资源对应url")
    private String resourceUrl;

    @ApiModelProperty(value = "资源名称")
    private String resourceName;

    @ApiModelProperty(value = "展示顺序")
    private Integer displaySort;

    @ApiModelProperty(value = "父节点资源")
    private String parentId;

    @ApiModelProperty(value = "资源类型：0-菜单；1-页面元素；2-接口")
    private Integer resourceType;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "图标")
    private String icon;

    @ApiModelProperty(value = "关联应用")
    private String applicationId;

    @ApiModelProperty(value = "状态： 0 禁用 1启用")
    private Integer status;

    @ApiModelProperty(value = "是否包含所有子节点")
    private boolean allChild;

    @ApiModelProperty(value = "树形结构编码，用于所有子节点搜索")
    private String treeCode;
}
