package com.cusc.nirvana.user.ciam.dto;

import com.cusc.nirvana.user.ciam.common.BaseIamDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 终端用户三方认证(UserThirdparty)传输对象类
 *
 * @author yuy336
 * @since 2022-05-05 19:54:32
 */
@ApiModel(value = "终端用户三方认证", description = "终端用户三方认证")
@Data
public class CiamUserThirdpartyDTO extends BaseIamDTO {

    private static final long serialVersionUID = -40258828458191027L;
    
    @ApiModelProperty(value = "业务主键")
    private String uuid;
    
    @ApiModelProperty(value = "终端用户id（ciam_user）")
    private String userId;
    
    @ApiModelProperty(value = "认证类型:1 微信  2 支付宝 3 钉钉")
    private Integer thirdPartyType;
    
    @ApiModelProperty(value = "三方id")
    private String thirdPartyId;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "分表路由键")
    private Long routingKey;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;
}

