package com.cusc.nirvana.user.auth.identification.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;

/**
 * Description: 用户名登录请求
 * <br />
 * CreateDate 2021-11-02 19:33:22
 *
 * @author yuyi
 **/
@ApiModel(value = "用户名登录请求", description = "用户名登录请求")
@Data
public class UserNameLoginReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "请求id", example = "19ea9376058241eca9ce07530fb66f76")
    private String requestId;

    @ApiModelProperty(value = "用户名", example = "zhangsan")
    private String userName;

    @ApiModelProperty(value = "密码", example = "密码密文")
    private String password;

    @ApiModelProperty(value = "应用id", example = "1")
    private String applicationId;

    @ApiModelProperty(value = "租户编号", example = "1")
    private String tenantNo;
}
