package com.cusc.nirvana.user.auth.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;
import java.util.List;

/**
 * Description: 短信发送dto
 * <br />
 * CreateDate 2021-11-02 19:33:22
 *
 * @author yuyi
 **/
@ApiModel(value = "短信发送dto", description = "短信发送dto")
@Data
public class SmsSendDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("请求key，短信网关提供")
    private String accesskey;

    @ApiModelProperty("短信推送,透传字段")
    private String callbackParam;

    @ApiModelProperty("手机号码集合")
    private List<String> phoneNumbers;

    @ApiModelProperty("短信签名Code")
    private String signatureCode;

    @ApiModelProperty("推送策略Code")
    private String strategyCode;

    @ApiModelProperty("短信模板Code")
    private String templateCode;

    @ApiModelProperty("短信模板参数")
    private List<String> templateParams;

    @ApiModelProperty("短信推送透传字段")
    private String upstreamCallbackParam;
}
