package com.cusc.nirvana.user.eiam.dto;

import com.cusc.nirvana.user.eiam.common.BaseIamPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 针对内部员工、生态合作伙伴、分级线下店铺等企业内部用户
 * </p>
 *
 * @author yuy336
 * @since 2021-10-20
 */
@ApiModel(value = "UserDTO对象", description = "针对内部员工、生态合作伙伴、分级线下店铺等企业内部用户")
@Data
public class UserDTO extends BaseIamPageDTO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户名")
    private String userName;

    @ApiModelProperty(value = "昵称")
    private String nickName;

    @ApiModelProperty(value = "用户姓名")
    private String fullName;

    @ApiModelProperty(value = "用户密码")
    private String password;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "用户状态：0 禁用 1启用")
    private Integer status;

    @ApiModelProperty(value = "是否是平台管理员 0 不是 1 是")
    private Integer isPlatformAdmin;

    @ApiModelProperty(value = "是否是租户管理员 0 不是 1 是")
    private Integer isTenantAdmin;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "工号")
    private String empNo;

    @ApiModelProperty(value = "入职时间")
    private Date entryDate;

    @ApiModelProperty(value = "用户uuid集合")
    private List<String> uuidList;

    @ApiModelProperty(value = "租户编号集合")
    private List<String> tenantNoList;

    @ApiModelProperty(value = "角色集合")
    private List<RoleSimpleDTO> roleList;

    @ApiModelProperty(value = "租户集合")
    private List<TenantSimpleDTO> tenantList;

    @ApiModelProperty(value = "新用户id")
    private String newUserId;

    @ApiModelProperty(value = "应用id")
    private String applicationId;

    @ApiModelProperty(value = "新密码")
    private String newPassword;

    @ApiModelProperty(value = "短信发送配置")
    private SmsSendConfig smsSendConfig;

	@ApiModelProperty(value = "查询组织id")
    private String queryOrganId;

	@ApiModelProperty(value = "普通管理员类型 0:不是任何管理员 1:车企经销商管理员")
	private Integer ordinaryAdmin;
}
