package com.cusc.nirvana.user.eiam.dto;

import com.cusc.nirvana.user.eiam.common.BaseIamPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 角色租户信息表(RoleTenant)传输对象类
 *
 * @author yuy336
 * @since 2022-01-12 15:01:33
 */
@ApiModel(value = "角色租户信息表", description = "角色租户信息表")
@Data
public class RoleTenantDTO extends BaseIamPageDTO {

    private static final long serialVersionUID = -14598847304289815L;

    @ApiModelProperty(value = "角色类型：1 租户角色  2 用户角色")
    private Integer roleScene;
    
    @ApiModelProperty(value = "角色uuid")
    private String roleId;

    @ApiModelProperty(value = "角色uuid集合")
    private List<String> roleIdList;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "租户编号集合")
    private List<String> tenantNoList;
    
    @ApiModelProperty(value = "应用id")
    private String applicationId;

    @ApiModelProperty(value = "应用id集合")
    private List<String> appIdList;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

}

