package com.cusc.nirvana.user.eiam.constants;

/**
 * Description: 资源授权类型枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum ResourceAuthTypeEnum {

    ROLE(1, "角色授权"),
    USER(2, "用户直接授权");

    private int code;
    private String name;

    ResourceAuthTypeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static ResourceAuthTypeEnum getEnumByCode(int code) {
        for (ResourceAuthTypeEnum sys : ResourceAuthTypeEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
