/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.workorder.job;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cache.CacheFactory;
import com.cusc.nirvana.common.loader.CollectionUtils;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.client.UserClient;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.rnr.common.po.BaseRnrPO;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgOrderApproverPO;
import com.cusc.nirvana.user.rnr.mg.service.IMgOrderApproverService;
import com.cusc.nirvana.user.rnr.workorder.constants.WorkOrderTypeEnum;
import com.cusc.nirvana.user.rnr.workorder.context.WorkOrderContext;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderAssignDTO;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderInfoDTO;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderQueryRequestDTO;
import com.cusc.nirvana.user.rnr.workorder.handler.WorkOrderHandler;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkOrderJob {
    private static final Logger log = LoggerFactory.getLogger(WorkOrderJob.class);
    @Resource
    private WorkOrderContext workOrderContext;
    @Resource
    private IMgOrderApproverService mgOrderApproverService;
    @Resource
    private CacheFactory cacheFactory;
    @Resource
    private UserClient userClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignWorkOrderJob() {
        try {
            int returnSize;
            Boolean lock = this.cacheFactory.getLockService().lock("CT:RNR:WORK_ORDER:CONFIG", "assginWorkOrderJob", 600);
            if (!lock.booleanValue()) {
                log.error("WorkOrderJob assignWorkOrderJob has lock");
                return;
            }
            WorkOrderHandler handler = this.workOrderContext.getHandler();
            int pageNumber = 1;
            int pageSize = 50;
            String applicationUuid = "b05ccb27c2d54113bf32a7203ef4b7a7";
            do {
                WorkOrderQueryRequestDTO dto = new WorkOrderQueryRequestDTO();
                dto.setApplicationUuid(applicationUuid);
                dto.setWorkOrderKey(WorkOrderTypeEnum.REAL_NAME_CERTIFICATION_ORDER.getKey());
                dto.setCurrPage(Integer.valueOf(pageNumber));
                dto.setPageSize(Integer.valueOf(pageSize));
                List workOrderList = handler.queryUnClaimedOrders(dto);
                returnSize = workOrderList.size();
                this.doAssignWorkOrder(workOrderList, handler);
                ++pageNumber;
            } while (returnSize == pageSize);
        }
        catch (Exception e) {
            log.error("WorkOrderJob assignWorkOrderJob has error", (Throwable)e);
        }
        finally {
            try {
                this.cacheFactory.getLockService().unLock("CT:RNR:WORK_ORDER:CONFIG");
            }
            catch (Exception e) {
                log.error("WorkOrderJob assignWorkOrderJob unLock has error", (Throwable)e);
            }
        }
    }

    private void doAssignWorkOrder(List<WorkOrderInfoDTO> workOrderList, WorkOrderHandler workOrderHandler) {
        if (CollectionUtils.isEmpty(workOrderList)) {
            return;
        }
        Map<String, List<WorkOrderInfoDTO>> groupByTenantUuidMap = workOrderList.stream().collect(Collectors.groupingBy(WorkOrderInfoDTO::getTenantUuid));
        groupByTenantUuidMap.forEach((tenantUuid, list) -> {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)query.eq(MgOrderApproverPO::getTenantNo, tenantUuid)).eq(MgOrderApproverPO::getStopAcceptOrder, (Object)0);
            List userApprovalList = this.mgOrderApproverService.list((Wrapper)query);
            if (CollectionUtils.isEmpty((Collection)userApprovalList)) {
                return;
            }
            List onLineUserList = userApprovalList.stream().filter(mgUserApprovalPo -> {
                UserDTO userDto = new UserDTO();
                userDto.setUuid(mgUserApprovalPo.getUserId());
                userDto.setApplicationId("4");
                userDto.setTenantNo(mgUserApprovalPo.getTenantNo());
                Response userOnline = this.userClient.getUserOnline(userDto);
                return null != userOnline && (Boolean)userOnline.getData() != false;
            }).sorted(Comparator.comparing(BaseRnrPO::getId)).collect(Collectors.toList());
            log.info("WorkOrderJob doAssignWorkOrder,tenantUuid = {},onLineList = {}", tenantUuid, (Object)JSONObject.toJSONString(onLineUserList));
            if (CollectionUtils.isEmpty(onLineUserList)) {
                return;
            }
            Long lastAssignUserId = this.getLastAssignUserId(tenantUuid);
            MgOrderApproverPO startApprovalUser = onLineUserList.stream().filter(mgUserApproval -> mgUserApproval.getId().compareTo(lastAssignUserId) > 0).min(Comparator.comparing(BaseRnrPO::getId)).orElse(null);
            Integer startIndex = null == startApprovalUser ? Integer.valueOf(0) : Integer.valueOf(onLineUserList.indexOf(startApprovalUser));
            Long lastApprovalUserId = 0L;
            for (int i = 0; i < list.size(); ++i) {
                WorkOrderInfoDTO workOrderInfoDTO = (WorkOrderInfoDTO)list.get(i);
                if (startIndex > onLineUserList.size() - 1) {
                    startIndex = 0;
                }
                MgOrderApproverPO mgOrderApproverPo = (MgOrderApproverPO)onLineUserList.get(startIndex);
                WorkOrderAssignDTO assignRequest = new WorkOrderAssignDTO();
                assignRequest.setApplicationUuid(workOrderInfoDTO.getApplicationUuid());
                assignRequest.setTenantUuid(workOrderInfoDTO.getTenantUuid());
                assignRequest.setTaskNo(workOrderInfoDTO.getTaskNo());
                assignRequest.setWorkOrderNo(workOrderInfoDTO.getWorkOrderNo());
                assignRequest.setWorkOrderKey(workOrderInfoDTO.getWorkOrderKey());
                assignRequest.setAssignUserId(mgOrderApproverPo.getUserId());
                workOrderHandler.assignWorkOrder(assignRequest);
                if (i == list.size() - 1) {
                    lastApprovalUserId = mgOrderApproverPo.getId();
                }
                Integer n = startIndex;
                Integer n2 = startIndex = Integer.valueOf(startIndex + 1);
            }
            this.saveLastAssignUserId(tenantUuid, lastApprovalUserId);
        });
    }

    private Long getLastAssignUserId(String tenantUuid) {
        Long lastAssignUserId;
        try {
            lastAssignUserId = (Long)this.cacheFactory.getStringService().getValue("CT:RNR:WOR_ORDER_ASSIGN:CONFIG:" + tenantUuid, Long.class);
        }
        catch (Exception e) {
            log.error("WorkOrderJob getLastAssignUserId has error,tenantUuid = {}", (Object)tenantUuid, (Object)e);
            lastAssignUserId = 0L;
        }
        return lastAssignUserId;
    }

    private void saveLastAssignUserId(String tenantUuid, Long lastApprovalUserId) {
        try {
            this.cacheFactory.getStringService().setValue("CT:RNR:WOR_ORDER_ASSIGN:CONFIG:" + tenantUuid, (Object)lastApprovalUserId);
        }
        catch (Exception e) {
            log.error("WorkOrderJob saveLastAssignUserId has error,tenantUuid = {},lastApprovalUserId = {}", new Object[]{tenantUuid, lastApprovalUserId, e});
        }
    }
}

