/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.workorder.handler.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cusc.nirvana.common.loader.CollectionUtils;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.constants.CryptKeyHelper;
import com.cusc.nirvana.user.rnr.mg.constants.NoticeStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrBizzTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrCardInfoConverter;
import com.cusc.nirvana.user.rnr.mg.dto.MgCardNoticeDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardNoticeService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IProjectService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderReviewCallBackRequestDTO;
import com.cusc.nirvana.user.rnr.workorder.handler.WorkOrderCallBackHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="unbindWorkOrderCallBackHandler")
public class UnbindWorkOrderCallBackHandler
implements WorkOrderCallBackHandler {
    private static final Logger log = LoggerFactory.getLogger(UnbindWorkOrderCallBackHandler.class);
    @Autowired
    IRnrOrderService orderService;
    @Autowired
    private IMgRnrInfoService rnrInfoService;
    @Autowired
    IMgRnrCardInfoService cardInfoService;
    @Autowired
    @Lazy
    private IMgRnrCardNoticeService cardNoticeService;
    @Autowired
    private IProjectService projectService;

    public void claimAssignWorkOrder(String workNo) {
    }

    public void reviewCallBack(WorkOrderReviewCallBackRequestDTO dto) {
        String orderId = dto.getBusinessObjectId();
        RnrOrderStatusEnum statusEnum = StringUtils.equalsIgnoreCase((CharSequence)dto.getAuditResult(), (CharSequence)"1") ? RnrOrderStatusEnum.PASS : RnrOrderStatusEnum.NOT_PASS;
        RnrOrderDTO rnrOrderDTO = new RnrOrderDTO();
        rnrOrderDTO.setUuid(orderId);
        RnrOrderDTO orderDTO = this.orderService.getByUuid(rnrOrderDTO);
        if (null == orderDTO) {
            log.error("UnbindWorkOrderCallBackHandler reviewCallBack orderDTO is null,dto = {} ", (Object)JSONObject.toJSONString((Object)dto));
            return;
        }
        String rnrId = orderDTO.getRnrId();
        List cardInfoDTOS = this.findCardsByRnrId(rnrId);
        ArrayList cardIds = new ArrayList();
        ArrayList rnrIds = new ArrayList();
        ArrayList mqList = new ArrayList();
        this.findUnboundInfo(cardInfoDTOS, mqList, cardIds, rnrIds);
        this.saveStatus(orderId, rnrId, cardIds, rnrIds, statusEnum);
        if (!CollectionUtils.isNotEmpty(mqList) && RnrOrderStatusEnum.PASS.equals((Object)statusEnum)) {
            this.cardNoticeService.sendCardNotice(mqList);
        }
    }

    @Transactional
    public void saveStatus(String orderId, String rnrId, List<String> cardIds, List<String> rnrIds, RnrOrderStatusEnum statusEnum) {
        this.orderService.updateOrderStatus(Collections.singletonList(orderId), statusEnum.getCode().intValue());
        if (statusEnum == RnrOrderStatusEnum.PASS) {
            this.rnrInfoService.updateRnrStatus(rnrId, RnrStatus.RNR);
            this.cardInfoService.updateCardStatusByOrderId(orderId, NoticeStatusEnum.NEED.getCode(), RnrStatus.UNBOUND.getCode());
        } else {
            this.rnrInfoService.updateRnrStatus(rnrId, RnrStatus.INIT);
            this.cardInfoService.updateCardStatusByOrderId(orderId, NoticeStatusEnum.NONEED.getCode(), RnrStatus.INIT.getCode());
        }
        if (CollectionUtils.isNotEmpty(cardIds) && RnrOrderStatusEnum.PASS.equals((Object)statusEnum)) {
            this.cardInfoService.unboundCardBatch(cardIds, RnrStatus.UNBOUND);
        }
    }

    private void findUnboundInfo(List<MgRnrCardInfoDTO> cardInfoDTOS, List<MgCardNoticeDTO> mqList, List<String> cardIds, List<String> rnrIds) {
        for (MgRnrCardInfoDTO cardInfoDTO : cardInfoDTOS) {
            List bindCards = this.findBindCards(cardInfoDTO.getIccid());
            for (MgRnrCardInfoDTO bindCard : bindCards) {
                cardIds.add(bindCard.getUuid());
                rnrIds.add(bindCard.getRnrId());
                MgCardNoticeDTO mgCardNoticeDTO = new MgCardNoticeDTO();
                mgCardNoticeDTO.setVin(bindCard.getIotId());
                mgCardNoticeDTO.setIccid(bindCard.getIccid());
                mgCardNoticeDTO.setRnrBizzType(RnrBizzTypeEnum.Unbound.getCode().intValue());
                mgCardNoticeDTO.setOrderId(bindCard.getOrderId());
                mqList.add(mgCardNoticeDTO);
            }
        }
    }

    private List<MgRnrCardInfoDTO> findBindCards(String iccid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"iccid", (Object)CryptKeyHelper.encrypt((String)iccid));
        queryWrapper.eq((Object)"rnr_status", (Object)RnrStatus.RNR.getCode());
        List list = this.cardInfoService.list((Wrapper)queryWrapper);
        return MgRnrCardInfoConverter.INSTANCE.poListToDtoList(list);
    }

    private List<MgRnrCardInfoDTO> findCardsByRnrId(String rnrId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"rnr_id", (Object)rnrId);
        List list = this.cardInfoService.list((Wrapper)queryWrapper);
        return MgRnrCardInfoConverter.INSTANCE.poListToDtoList(list);
    }
}

