/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.workorder.handler.impl;

import com.alibaba.fastjson.JSONObject;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.rnr.common.constants.ResponseCode;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderType;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrUnbindDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardNoticeService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrResultProcessService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrUnboundService;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderReviewCallBackRequestDTO;
import com.cusc.nirvana.user.rnr.workorder.handler.WorkOrderCallBackHandler;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="rnrWorkOrderCallBackHandler")
public class RnrWorkOrderCallBackHandler
implements WorkOrderCallBackHandler {
    private static final Logger log = LoggerFactory.getLogger(RnrWorkOrderCallBackHandler.class);
    @Autowired
    IRnrOrderService orderService;
    @Autowired
    IMgRnrCardInfoService cardInfoService;
    @Autowired
    @Lazy
    IMgRnrCardNoticeService cardNoticeService;
    @Autowired
    IMgRnrInfoService mgRnrInfoService;
    @Autowired
    IRnrUnboundService iRnrUnboundService;
    @Resource
    private IRnrResultProcessService processService;

    public void claimAssignWorkOrder(String workNo) {
    }

    public void reviewCallBack(WorkOrderReviewCallBackRequestDTO dto) {
        String orderId = dto.getBusinessObjectId();
        RnrOrderStatusEnum statusEnum = StringUtils.equalsIgnoreCase((CharSequence)dto.getAuditResult(), (CharSequence)"1") ? RnrOrderStatusEnum.PASS : RnrOrderStatusEnum.NOT_PASS;
        RnrOrderDTO rnrOrderDTO = new RnrOrderDTO();
        rnrOrderDTO.setUuid(orderId);
        RnrOrderDTO orderDTO = this.orderService.getByUuid(rnrOrderDTO);
        if (null == orderDTO) {
            log.error("RnrWorkOrderCallBackHandler reviewCallBack orderDTO is null,dto = {} ", (Object)JSONObject.toJSONString((Object)dto));
            return;
        }
        String rnrId = orderDTO.getRnrId();
        if (RnrOrderType.SEC_VEHICLE.getCode().equals(orderDTO.getOrderType())) {
            this.unboundCards(orderId, rnrId);
        }
        this.processService.processRnrResult(orderId, rnrId, statusEnum);
    }

    @Transactional
    public void unboundCards(String orderId, String rnrId) {
        MgRnrCardInfoDTO query = new MgRnrCardInfoDTO();
        query.setOrderId(orderId);
        query.setRnrId(rnrId);
        List mgRnrCardInfoDTOS = this.cardInfoService.queryByList(query);
        List iccids = mgRnrCardInfoDTOS.stream().map(card -> card.getIccid()).collect(Collectors.toList());
        query = new MgRnrCardInfoDTO();
        query.setIccidList(iccids);
        query.setRnrStatus(Integer.valueOf(RnrStatus.RNR.getCode()));
        mgRnrCardInfoDTOS = this.cardInfoService.queryByList(query);
        if (!CollectionUtils.isEmpty((Collection)mgRnrCardInfoDTOS)) {
            for (MgRnrCardInfoDTO cardDto : mgRnrCardInfoDTOS) {
                MgRnrInfoDTO mgRnrInfoDTO = new MgRnrInfoDTO();
                mgRnrInfoDTO.setUuid(cardDto.getRnrId());
                MgRnrInfoDTO rnrInfoDTO = this.mgRnrInfoService.getByUuid(mgRnrInfoDTO);
                if (rnrInfoDTO == null) {
                    throw new CuscUserException("", "\u5b9e\u540d\u4e1a\u52a1\u3010" + cardDto.getRnrId() + "\u3011\u4e0d\u5b58\u5728");
                }
                RnrUnbindDTO unbindDTO = new RnrUnbindDTO();
                unbindDTO.setIccid(cardDto.getIccid());
                unbindDTO.setVin(cardDto.getIotId());
                unbindDTO.setCertNumber(rnrInfoDTO.getCertNumber());
                unbindDTO.setFullName(rnrInfoDTO.getFullName());
                unbindDTO.setCertType(rnrInfoDTO.getCertType());
                unbindDTO.setPhone(rnrInfoDTO.getPhone());
                unbindDTO.setReason(Integer.valueOf(3));
                unbindDTO.setManualUnbind(false);
                Response response = this.iRnrUnboundService.rnrUnbound(unbindDTO);
                if (null != response && (response.getSuccess().booleanValue() || response.getCode() == ResponseCode.ICCID_RNR_INFO_NOT_MATCHED.getCode())) continue;
                throw new CuscUserException("", "\u89e3\u7ed1\u5361[" + cardDto.getIccid() + "]\u5931\u8d25");
            }
        }
    }
}

