/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.workorder.handler.impl;

import com.alibaba.fastjson.JSONObject;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.dto.MgVehicleCompanyDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardNoticeService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgVehicleCompanyService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrResultProcessService;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderReviewCallBackRequestDTO;
import com.cusc.nirvana.user.rnr.workorder.handler.WorkOrderCallBackHandler;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="manufacturerRnrCallBackHandler")
public class ManufacturerRnrCallBackHandler
implements WorkOrderCallBackHandler {
    private static final Logger log = LoggerFactory.getLogger(ManufacturerRnrCallBackHandler.class);
    @Autowired
    IRnrOrderService orderService;
    @Autowired
    IMgRnrCardInfoService cardInfoService;
    @Autowired
    @Lazy
    IMgRnrCardNoticeService cardNoticeService;
    @Autowired
    IMgRnrInfoService mgRnrInfoService;
    @Autowired
    IMgVehicleCompanyService mgVehicleCompanyService;
    @Resource
    private IRnrResultProcessService processService;

    public void claimAssignWorkOrder(String workNo) {
    }

    public void reviewCallBack(WorkOrderReviewCallBackRequestDTO dto) {
        String orderId = dto.getBusinessObjectId();
        RnrOrderStatusEnum statusEnum = StringUtils.equalsIgnoreCase((CharSequence)dto.getAuditResult(), (CharSequence)"1") ? RnrOrderStatusEnum.PASS : RnrOrderStatusEnum.NOT_PASS;
        RnrOrderDTO rnrOrderDTO = new RnrOrderDTO();
        rnrOrderDTO.setUuid(orderId);
        RnrOrderDTO orderDTO = this.orderService.getByUuid(rnrOrderDTO);
        if (null == orderDTO) {
            log.error("ManufacturerRnrCallBackHandler reviewCallBack orderDTO is null,dto = {} ", (Object)JSONObject.toJSONString((Object)dto));
            return;
        }
        String rnrId = orderDTO.getRnrId();
        if (statusEnum == RnrOrderStatusEnum.PASS) {
            MgVehicleCompanyDTO mvc = new MgVehicleCompanyDTO();
            mvc.setTenantNo(orderDTO.getTenantNo());
            mvc.setOrgId(orderDTO.getOrgId());
            mvc = this.mgVehicleCompanyService.getVehicleCompany(mvc);
            if (mvc == null) {
                mvc = new MgVehicleCompanyDTO();
                mvc.setFirstRnrId(rnrId);
                mvc.setOrgId(orderDTO.getOrgId());
                mvc.setTenantNo(orderDTO.getTenantNo());
                mvc.setCreator(orderDTO.getCreator());
                this.mgVehicleCompanyService.saveByRnrId(mvc);
            }
        }
        this.processService.processRnrResult(orderId, rnrId, statusEnum);
    }
}

