/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.workorder.handler.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrCardInfoPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardNoticeService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IProjectService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrResultProcessService;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderReviewCallBackRequestDTO;
import com.cusc.nirvana.user.rnr.workorder.handler.WorkOrderCallBackHandler;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EnterpriseChangeCallBackHandler
implements WorkOrderCallBackHandler {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseChangeCallBackHandler.class);
    @Resource
    private IRnrOrderService orderService;
    @Resource
    private IMgRnrInfoService mgRnrInfoService;
    @Resource
    private IMgRnrCardInfoService cardInfoService;
    @Resource
    @Lazy
    private IMgRnrCardNoticeService noticeService;
    @Autowired
    private IProjectService projectService;
    @Resource
    private IRnrResultProcessService processService;

    public void claimAssignWorkOrder(String workNo) {
    }

    public void reviewCallBack(WorkOrderReviewCallBackRequestDTO dto) {
        boolean auditResult = StringUtils.equalsIgnoreCase((CharSequence)dto.getAuditResult(), (CharSequence)"1");
        String orderId = dto.getBusinessObjectId();
        RnrOrderDTO orderQuery = new RnrOrderDTO();
        orderQuery.setUuid(orderId);
        RnrOrderDTO orderDTO = this.orderService.getByUuid(orderQuery);
        if (null == orderDTO) {
            log.error("EnterpriseChangeCallBackHandler reviewCallBack orderDTO is null,dto = {} ", (Object)JSONObject.toJSONString((Object)dto));
            return;
        }
        MgRnrInfoDTO infoQuery = new MgRnrInfoDTO();
        infoQuery.setUuid(orderDTO.getRnrId());
        MgRnrInfoDTO rnrInfo = this.mgRnrInfoService.getByUuid(infoQuery);
        if (null == rnrInfo) {
            log.error("EnterpriseChangeCallBackHandler reviewCallBack rnrInfo is null,dto = {} ", (Object)JSONObject.toJSONString((Object)dto));
            return;
        }
        MgRnrCardInfoDTO cardQuery = new MgRnrCardInfoDTO();
        cardQuery.setRnrId(rnrInfo.getUuid());
        List cardInfoDTOList = this.cardInfoService.queryByList(cardQuery);
        if (CollectionUtils.isEmpty((Collection)cardInfoDTOList)) {
            log.error("EnterpriseChangeCallBackHandler reviewCallBack cardInfoDTOList is empty,dto = {} ", (Object)JSONObject.toJSONString((Object)dto));
            return;
        }
        this.processService.processRnrResult(orderId, rnrInfo.getUuid(), auditResult ? RnrOrderStatusEnum.PASS : RnrOrderStatusEnum.NOT_PASS);
        if (auditResult) {
            this.unBindOldCard(cardInfoDTOList);
        }
    }

    private void unBindOldCard(List<MgRnrCardInfoDTO> cardInfoDTOList) {
        cardInfoDTOList.parallelStream().forEach(card -> {
            if (StringUtils.isNotBlank((CharSequence)card.getOldCardId())) {
                MgRnrCardInfoPO updateCardPo = new MgRnrCardInfoPO();
                updateCardPo.setRnrStatus(Integer.valueOf(RnrStatus.UNBOUND.getCode()));
                LambdaQueryWrapper cardQuery = new LambdaQueryWrapper();
                cardQuery.eq(MgRnrCardInfoPO::getUuid, (Object)card.getOldCardId());
                this.cardInfoService.update((Object)updateCardPo, (Wrapper)cardQuery);
            }
        });
    }
}

