/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.workorder.controller;

import com.cusc.nirvana.common.result.BaseEnum;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.workorder.constants.WorkOrderTypeEnum;
import com.cusc.nirvana.user.rnr.workorder.context.WorkOrderContext;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderClaimRequestDTO;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderInfoDTO;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderQueryRequestDTO;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderReviewDTO;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderStarRequestDTO;
import com.cusc.nirvana.user.rnr.workorder.handler.WorkOrderHandler;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rnr/worktest"})
public class WorkTestController {
    private static final Logger log = LoggerFactory.getLogger(WorkTestController.class);
    @Resource
    private WorkOrderContext workOrderContext;

    @GetMapping(value={"/startWork"})
    public Response<String> startWork(@RequestParam(value="id") String id) {
        WorkOrderHandler handler = this.workOrderContext.getHandler();
        WorkOrderStarRequestDTO dto = new WorkOrderStarRequestDTO();
        dto.setTenantUuid("test1");
        dto.setApplicationUuid("b05ccb27c2d54113bf32a7203ef4b7a7");
        dto.setBusinessObjectId("test" + id);
        dto.setName("test" + id);
        dto.setStartUserId("test");
        dto.setWorkOrderKey(WorkOrderTypeEnum.REAL_NAME_CERTIFICATION_ORDER.getKey());
        String workOrderNo = handler.startOrder(dto);
        return Response.createSuccess((String)BaseEnum.SUCCESS.getMsg(), (Object)workOrderNo);
    }

    @GetMapping(value={"/queryUnClaimedOrders"})
    public Response<List<WorkOrderInfoDTO>> queryUnClaimedOrders() {
        WorkOrderHandler handler = this.workOrderContext.getHandler();
        WorkOrderQueryRequestDTO dto = new WorkOrderQueryRequestDTO();
        dto.setApplicationUuid("b05ccb27c2d54113bf32a7203ef4b7a7");
        dto.setTenantUuid("test1");
        dto.setWorkOrderKey(WorkOrderTypeEnum.REAL_NAME_CERTIFICATION_ORDER.getKey());
        dto.setCurrPage(Integer.valueOf(1));
        dto.setPageSize(Integer.valueOf(30));
        List list = handler.queryUnClaimedOrders(dto);
        return Response.createSuccess((Object)list);
    }

    @GetMapping(value={"/claimOrder"})
    public Response<Boolean> claimOrder(@RequestParam(value="taskNo") String taskNo, @RequestParam(value="claimUserId") String claimUserId) {
        WorkOrderHandler handler = this.workOrderContext.getHandler();
        WorkOrderClaimRequestDTO dto = new WorkOrderClaimRequestDTO();
        dto.setApplicationUuid("b05ccb27c2d54113bf32a7203ef4b7a7");
        dto.setTenantUuid("test1");
        dto.setWorkOrderKey(WorkOrderTypeEnum.REAL_NAME_CERTIFICATION_ORDER.getKey());
        dto.setTaskNo(taskNo);
        dto.setClaimUserId(claimUserId);
        return Response.createSuccess((Object)handler.claimOrder(dto));
    }

    @GetMapping(value={"/queryClaimedOrders"})
    public Response<List<WorkOrderInfoDTO>> queryClaimedOrders(@RequestParam(value="claimUserId") String claimUserId) {
        WorkOrderHandler handler = this.workOrderContext.getHandler();
        WorkOrderQueryRequestDTO dto = new WorkOrderQueryRequestDTO();
        dto.setApplicationUuid("b05ccb27c2d54113bf32a7203ef4b7a7");
        dto.setTenantUuid("test1");
        dto.setWorkOrderKey(WorkOrderTypeEnum.REAL_NAME_CERTIFICATION_ORDER.getKey());
        dto.setCurrPage(Integer.valueOf(1));
        dto.setPageSize(Integer.valueOf(30));
        dto.setClaimUserId(claimUserId);
        List list = handler.queryClaimedOrders(dto);
        return Response.createSuccess((Object)list);
    }

    @GetMapping(value={"/reviewWorkOrder"})
    public Response reviewWorkOrder(@RequestParam(value="reviewUserId") String reviewUserId, @RequestParam(value="taskNo") String taskNo, @RequestParam(value="auditResult") Integer auditResult, @RequestParam(value="auditNote") String auditNote) {
        WorkOrderHandler handler = this.workOrderContext.getHandler();
        WorkOrderReviewDTO dto = new WorkOrderReviewDTO();
        dto.setApplicationUuid("b05ccb27c2d54113bf32a7203ef4b7a7");
        dto.setTenantUuid("test1");
        dto.setReviewUserId(reviewUserId);
        dto.setTaskNo(taskNo);
        dto.setAuditResult(auditResult);
        dto.setAuditNote(auditNote);
        Boolean success = handler.reviewWorkOrder(dto);
        return Response.createSuccess((Object)success);
    }
}

