/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.constants.CommonYesOrNoEnum;
import com.cusc.nirvana.user.rnr.mg.util.Md5CaculateUtil;
import com.cusc.nirvana.user.rnr.notice.constants.NoticeUrlTypeEnum;
import com.cusc.nirvana.user.rnr.notice.converter.RnrNoticeContentConverter;
import com.cusc.nirvana.user.rnr.notice.converter.ThirdPartyNoticeConverter;
import com.cusc.nirvana.user.rnr.notice.dao.RnrNoticeContentDao;
import com.cusc.nirvana.user.rnr.notice.dao.entity.RnrNoticeContentPO;
import com.cusc.nirvana.user.rnr.notice.dto.RnrNoticeConfigDTO;
import com.cusc.nirvana.user.rnr.notice.dto.RnrNoticeContentDTO;
import com.cusc.nirvana.user.rnr.notice.dto.RnrNoticeContentLogDTO;
import com.cusc.nirvana.user.rnr.notice.dto.RnrNoticeReqDTO;
import com.cusc.nirvana.user.rnr.notice.dto.ThirdPartyNoticeReqDTO;
import com.cusc.nirvana.user.rnr.notice.service.IRnrNoticeConfigService;
import com.cusc.nirvana.user.rnr.notice.service.IRnrNoticeContentLogService;
import com.cusc.nirvana.user.rnr.notice.service.IRnrNoticeContentService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class RnrNoticeContentServiceImpl
extends ServiceImpl<RnrNoticeContentDao, RnrNoticeContentPO>
implements IRnrNoticeContentService {
    @Autowired
    private IRnrNoticeContentLogService rnrNoticeContentLogService;
    @Autowired
    private IRnrNoticeConfigService rnrNoticeConfigService;
    @Autowired
    @Qualifier(value="restTemplate")
    public RestTemplate restTemplate;
    @Autowired
    @Qualifier(value="thirdPartyRnr")
    public RestTemplate thirdPartyRnr;

    public RnrNoticeContentDTO getByUuid(RnrNoticeContentDTO bean) {
        RnrNoticeContentPO record = this.getPoByUuid(bean.getUuid());
        return RnrNoticeContentConverter.INSTANCE.poToDto(record);
    }

    public List<RnrNoticeContentDTO> queryByList(RnrNoticeContentDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return RnrNoticeContentConverter.INSTANCE.poListToDtoList(record);
    }

    @Transactional
    public RnrNoticeContentDTO insert(RnrNoticeContentDTO bean) {
        RnrNoticeContentPO rnrNoticeContentPO = RnrNoticeContentConverter.INSTANCE.dtoToPo(bean);
        if (StringUtils.isEmpty((Object)rnrNoticeContentPO.getUuid())) {
            rnrNoticeContentPO.setUuid(CuscStringUtils.generateUuid());
        }
        this.save((Object)rnrNoticeContentPO);
        bean.setUuid(rnrNoticeContentPO.getUuid());
        return bean;
    }

    @Transactional
    public RnrNoticeContentDTO update(RnrNoticeContentDTO bean) {
        RnrNoticeContentPO rnrNoticeContentPO = this.getPoByUuid(bean.getUuid());
        if (rnrNoticeContentPO == null) {
            return null;
        }
        RnrNoticeContentPO tmpBean = RnrNoticeContentConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(rnrNoticeContentPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(RnrNoticeContentDTO bean) {
        RnrNoticeContentPO rnrNoticeContentPO = this.getPoByUuid(bean.getUuid());
        if (rnrNoticeContentPO == null) {
            return false;
        }
        RnrNoticeContentPO tmpBean = new RnrNoticeContentPO();
        tmpBean.setId(rnrNoticeContentPO.getId());
        return this.updateById((Object)tmpBean);
    }

    @Transactional
    public boolean noticeThreePartySystem(RnrNoticeReqDTO bean) {
        boolean ret = false;
        RnrNoticeConfigDTO config = new RnrNoticeConfigDTO();
        config.setNoticeSubject(bean.getNoticeSubject());
        List noticeConfigList = this.rnrNoticeConfigService.queryBySubjectAndTypeCache(config);
        if (CollectionUtils.isEmpty((Collection)noticeConfigList)) {
            return ret;
        }
        ThirdPartyNoticeReqDTO tpNoticeReq = ThirdPartyNoticeConverter.INSTANCE.noticeReqToThirdPartyDto(bean);
        for (RnrNoticeConfigDTO noticeConfig : noticeConfigList) {
            RnrNoticeContentDTO contentDTO = new RnrNoticeContentDTO();
            contentDTO.setNoticeConfigId(noticeConfig.getUuid());
            contentDTO.setNoticeSubject(noticeConfig.getNoticeSubject());
            contentDTO.setRnrBizzType(noticeConfig.getRnrBizzType());
            contentDTO.setCount(Integer.valueOf(1));
            RnrNoticeContentLogDTO logDTO = new RnrNoticeContentLogDTO();
            logDTO.setRequestTime(new Date());
            logDTO.setTraceId(TraceContext.traceId());
            Response thirdResp = this.thirdPartyNotice(noticeConfig, tpNoticeReq);
            logDTO.setResponseMsg(JSON.toJSONString((Object)thirdResp));
            logDTO.setResponseTime(new Date());
            if (thirdResp.getSuccess().booleanValue()) {
                logDTO.setIsSuccess(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()));
                contentDTO.setNoticeStatus(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()));
                ret = true;
            } else {
                logDTO.setIsSuccess(Integer.valueOf(CommonYesOrNoEnum.NO.getCode()));
                contentDTO.setNoticeStatus(Integer.valueOf(CommonYesOrNoEnum.NO.getCode()));
            }
            contentDTO.setNoticeContent(JSON.toJSONString((Object)tpNoticeReq));
            contentDTO = this.insert(contentDTO);
            logDTO.setNoticeContentId(contentDTO.getUuid());
            this.rnrNoticeContentLogService.insert(logDTO);
        }
        return ret;
    }

    public boolean noticeThreePartySystemRetry(RnrNoticeContentDTO bean) {
        boolean ret = false;
        RnrNoticeConfigDTO config = new RnrNoticeConfigDTO();
        config.setNoticeSubject(bean.getNoticeSubject());
        config.setRnrBizzType(bean.getRnrBizzType());
        List noticeConfigList = this.rnrNoticeConfigService.queryBySubjectAndTypeCache(config);
        if (CollectionUtils.isEmpty((Collection)noticeConfigList)) {
            return ret;
        }
        ThirdPartyNoticeReqDTO tpNoticeReq = (ThirdPartyNoticeReqDTO)JSON.parseObject((String)bean.getNoticeContent(), ThirdPartyNoticeReqDTO.class);
        config = null;
        for (RnrNoticeConfigDTO noticeConfig : noticeConfigList) {
            if (!noticeConfig.getUuid().equals(bean.getNoticeConfigId())) continue;
            config = noticeConfig;
        }
        RnrNoticeContentLogDTO logDTO = new RnrNoticeContentLogDTO();
        logDTO.setRequestTime(new Date());
        logDTO.setTraceId(TraceContext.traceId());
        if (config != null) {
            RnrNoticeContentDTO contentDTO = new RnrNoticeContentDTO();
            contentDTO.setUuid(bean.getUuid());
            Response thirdResp = this.thirdPartyNotice(config, tpNoticeReq);
            logDTO.setResponseMsg(JSON.toJSONString((Object)thirdResp));
            logDTO.setResponseTime(new Date());
            if (thirdResp.getSuccess().booleanValue()) {
                logDTO.setIsSuccess(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()));
                contentDTO.setNoticeStatus(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()));
                ret = true;
            } else {
                logDTO.setIsSuccess(Integer.valueOf(CommonYesOrNoEnum.NO.getCode()));
                contentDTO.setCount(Integer.valueOf(bean.getCount() + 1));
            }
        } else {
            logDTO.setResponseMsg("\u901a\u77e5\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        logDTO.setNoticeContentId(bean.getUuid());
        this.rnrNoticeContentLogService.insert(logDTO);
        return ret;
    }

    private RnrNoticeContentPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (RnrNoticeContentPO)this.getOne((Wrapper)queryWrapper);
    }

    private Response thirdPartyNotice(RnrNoticeConfigDTO noticeConfig, ThirdPartyNoticeReqDTO tpNoticeReq) {
        Response ret;
        if (NoticeUrlTypeEnum.SERVER_NAME.getCode() == noticeConfig.getUrlType().intValue()) {
            ret = (Response)this.restTemplate.postForObject(noticeConfig.getUrl(), (Object)tpNoticeReq, Response.class, new Object[0]);
        } else {
            HttpEntity reqHttpEntity = CommonYesOrNoEnum.YES.getCode() == noticeConfig.getIsSign().intValue() ? new HttpEntity((Object)tpNoticeReq, (MultiValueMap)this.builderHttpHeaders(noticeConfig)) : new HttpEntity((Object)tpNoticeReq);
            ret = (Response)this.thirdPartyRnr.postForObject(noticeConfig.getUrl(), (Object)reqHttpEntity, Response.class, new Object[0]);
        }
        return ret;
    }

    private HttpHeaders builderHttpHeaders(RnrNoticeConfigDTO noticeConfig) {
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        String currentTimeStr = DateUtils.currentTimeStr();
        String nonce = CuscStringUtils.generateUuid();
        requestHeaders.set("appid", noticeConfig.getAppId());
        requestHeaders.set("timestamp", currentTimeStr);
        requestHeaders.set("serialNumber", "");
        StringBuffer sbr = new StringBuffer();
        sbr.append("appid=");
        sbr.append(noticeConfig.getAppId());
        sbr.append("&timestamp=");
        sbr.append(currentTimeStr);
        sbr.append("&serialNumber=");
        sbr.append(nonce);
        sbr.append("&appkey=");
        sbr.append(noticeConfig.getAppKey());
        requestHeaders.set("sign", Md5CaculateUtil.MD5((String)sbr.toString()));
        return requestHeaders;
    }
}

