/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.notice.converter.RnrNoticeContentLogConverter;
import com.cusc.nirvana.user.rnr.notice.dao.RnrNoticeContentLogDao;
import com.cusc.nirvana.user.rnr.notice.dao.entity.RnrNoticeContentLogPO;
import com.cusc.nirvana.user.rnr.notice.dto.RnrNoticeContentLogDTO;
import com.cusc.nirvana.user.rnr.notice.service.IRnrNoticeContentLogService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RnrNoticeContentLogServiceImpl
extends ServiceImpl<RnrNoticeContentLogDao, RnrNoticeContentLogPO>
implements IRnrNoticeContentLogService {
    public RnrNoticeContentLogDTO getByUuid(RnrNoticeContentLogDTO bean) {
        RnrNoticeContentLogPO record = this.getPoByUuid(bean.getUuid());
        return RnrNoticeContentLogConverter.INSTANCE.poToDto(record);
    }

    public List<RnrNoticeContentLogDTO> queryByList(RnrNoticeContentLogDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return RnrNoticeContentLogConverter.INSTANCE.poListToDtoList(record);
    }

    @Transactional
    public RnrNoticeContentLogDTO insert(RnrNoticeContentLogDTO bean) {
        RnrNoticeContentLogPO rnrNoticeContentLogPO = RnrNoticeContentLogConverter.INSTANCE.dtoToPo(bean);
        rnrNoticeContentLogPO.setUuid(CuscStringUtils.generateUuid());
        this.save((Object)rnrNoticeContentLogPO);
        bean.setUuid(rnrNoticeContentLogPO.getUuid());
        return bean;
    }

    @Transactional
    public RnrNoticeContentLogDTO update(RnrNoticeContentLogDTO bean) {
        RnrNoticeContentLogPO rnrNoticeContentLogPO = this.getPoByUuid(bean.getUuid());
        if (rnrNoticeContentLogPO == null) {
            return null;
        }
        RnrNoticeContentLogPO tmpBean = RnrNoticeContentLogConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(rnrNoticeContentLogPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(RnrNoticeContentLogDTO bean) {
        RnrNoticeContentLogPO rnrNoticeContentLogPO = this.getPoByUuid(bean.getUuid());
        if (rnrNoticeContentLogPO == null) {
            return false;
        }
        RnrNoticeContentLogPO tmpBean = new RnrNoticeContentLogPO();
        tmpBean.setId(rnrNoticeContentLogPO.getId());
        return this.updateById((Object)tmpBean);
    }

    private RnrNoticeContentLogPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (RnrNoticeContentLogPO)this.getOne((Wrapper)queryWrapper);
    }
}

