/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cache.annotation.tag.Cache;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.notice.converter.RnrNoticeConfigConverter;
import com.cusc.nirvana.user.rnr.notice.dao.RnrNoticeConfigDao;
import com.cusc.nirvana.user.rnr.notice.dao.entity.RnrNoticeConfigPO;
import com.cusc.nirvana.user.rnr.notice.dto.RnrNoticeConfigDTO;
import com.cusc.nirvana.user.rnr.notice.service.IRnrNoticeConfigService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RnrNoticeConfigServiceImpl
extends ServiceImpl<RnrNoticeConfigDao, RnrNoticeConfigPO>
implements IRnrNoticeConfigService {
    public RnrNoticeConfigDTO getByUuid(RnrNoticeConfigDTO bean) {
        RnrNoticeConfigPO record = this.getPoByUuid(bean.getUuid());
        return RnrNoticeConfigConverter.INSTANCE.poToDto(record);
    }

    public List<RnrNoticeConfigDTO> queryByNoticeSubject(RnrNoticeConfigDTO bean) {
        List record = this.getPoByNoticeSubject(bean);
        return RnrNoticeConfigConverter.INSTANCE.poListToDtoList(record);
    }

    public List<RnrNoticeConfigDTO> queryByList(RnrNoticeConfigDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return RnrNoticeConfigConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<RnrNoticeConfigDTO> queryByPage(RnrNoticeConfigDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, RnrNoticeConfigDTO.class);
    }

    @Transactional
    @Cache(keyPrefix="CT:RNR:NOTICE:CONFIG:", key="#bean.noticeSubject+\"_\"+#bean.noticeType", level1="redis", action=0)
    public RnrNoticeConfigDTO insert(RnrNoticeConfigDTO bean) {
        RnrNoticeConfigPO rnrNoticeConfigPO = RnrNoticeConfigConverter.INSTANCE.dtoToPo(bean);
        rnrNoticeConfigPO.setUuid(CuscStringUtils.generateUuid());
        this.save((Object)rnrNoticeConfigPO);
        bean.setUuid(rnrNoticeConfigPO.getUuid());
        return bean;
    }

    @Transactional
    @Cache(keyPrefix="CT:RNR:NOTICE:CONFIG:", key="#bean.noticeSubject+\"_\"+#bean.noticeType", level1="redis", action=0)
    public RnrNoticeConfigDTO update(RnrNoticeConfigDTO bean) {
        RnrNoticeConfigPO rnrNoticeConfigPO = this.getPoByUuid(bean.getUuid());
        if (rnrNoticeConfigPO == null) {
            return null;
        }
        RnrNoticeConfigPO tmpBean = RnrNoticeConfigConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(rnrNoticeConfigPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    @Cache(keyPrefix="CT:RNR:NOTICE:CONFIG:", key="#bean.noticeSubject+\"_\"+#bean.noticeType", level1="redis", action=0)
    public boolean deleteById(RnrNoticeConfigDTO bean) {
        RnrNoticeConfigPO rnrNoticeConfigPO = this.getPoByUuid(bean.getUuid());
        if (rnrNoticeConfigPO == null) {
            return false;
        }
        RnrNoticeConfigPO tmpBean = new RnrNoticeConfigPO();
        tmpBean.setId(rnrNoticeConfigPO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    @Cache(keyPrefix="CT:RNR:NOTICE:CONFIG:", key="#bean.noticeSubject+\"_\"+#bean.rnrBizzType", level1="redis")
    public List<RnrNoticeConfigDTO> queryBySubjectAndTypeCache(RnrNoticeConfigDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"notice_subject", (Object)bean.getNoticeSubject());
        queryWrapper.eq((Object)"notice_type", (Object)bean.getRnrBizzType());
        try {
            List configListPO = this.list((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)configListPO)) {
                return null;
            }
            return RnrNoticeConfigConverter.INSTANCE.poListToDtoList(configListPO);
        }
        catch (Exception e) {
            this.log.error("queryBySubjectAndTypeCache  ", (Throwable)e);
            return null;
        }
    }

    private RnrNoticeConfigPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (RnrNoticeConfigPO)this.getOne((Wrapper)queryWrapper);
    }

    private List<RnrNoticeConfigPO> getPoByNoticeSubject(RnrNoticeConfigDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"notice_subject", (Object)bean.getNoticeSubject());
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return this.list((Wrapper)queryWrapper);
    }
}

