/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.dto.MgCardNoticeDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import com.cusc.nirvana.user.rnr.notice.dto.RnrNoticeConfigDTO;
import com.cusc.nirvana.user.rnr.notice.dto.RnrNoticeContentDTO;
import com.cusc.nirvana.user.rnr.notice.dto.RnrNoticeContentLogDTO;
import com.cusc.nirvana.user.rnr.notice.service.IRnrNoticeConfigService;
import com.cusc.nirvana.user.rnr.notice.service.IRnrNoticeContentLogService;
import com.cusc.nirvana.user.rnr.notice.service.IRnrNoticeContentService;
import com.cusc.nirvana.user.rnr.notice.service.NoticeHandler;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="noticeContentHandler")
public class NoticeContentHandler
implements NoticeHandler {
    private static final Logger log = LoggerFactory.getLogger(NoticeContentHandler.class);
    @Autowired
    private IRnrNoticeConfigService rnrNoticeConfigService;
    @Autowired
    private IRnrNoticeContentLogService rnrNoticeContentLogService;
    @Autowired
    private IRnrNoticeContentService rnrNoticeContentService;
    @Autowired
    @Qualifier(value="thirdPartyRnr")
    private RestTemplate thirdPartyRnr;

    public void handleNotice(MgCardNoticeDTO bean) {
        try {
            RnrNoticeConfigDTO paramDTO = new RnrNoticeConfigDTO();
            paramDTO.setNoticeSubject(bean.getManufacturerOrgId());
            paramDTO.setTenantNo(bean.getTenantNo());
            List rnrNoticeConfigList = this.rnrNoticeConfigService.queryByNoticeSubject(paramDTO);
            if (CollectionUtils.isEmpty((Collection)rnrNoticeConfigList)) {
                log.info("RnrNoticeConsumer notice config is null , request: {}", (Object)JSON.toJSONString((Object)bean));
                return;
            }
            for (RnrNoticeConfigDTO rnrNoticeConfigDTO : rnrNoticeConfigList) {
                String url = rnrNoticeConfigDTO.getUrl();
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                LinkedMultiValueMap parameters = new LinkedMultiValueMap();
                parameters.add((Object)"vin", (Object)bean.getVin());
                parameters.add((Object)"iccid", (Object)bean.getIccid());
                parameters.add((Object)"oldIccid", (Object)bean.getOldIccid());
                HttpEntity httpEntity = new HttpEntity((Object)parameters, (MultiValueMap)headers);
                Date requestTime = new Date();
                Response ret = (Response)RnrMgRestTemplateUtils.postForObject((RestTemplate)this.thirdPartyRnr, (String)url, (HttpEntity)httpEntity, Response.class, (Object[])new Object[0]);
                log.info("RnrNoticeConsumer end , url = {},request = {},response = {}", new Object[]{url, JSONObject.toJSONString((Object)parameters), JSONObject.toJSONString((Object)ret)});
                Date responseTime = new Date();
                Integer noticeStatus = null;
                noticeStatus = Objects.nonNull(ret) && ret.getSuccess() != false ? Integer.valueOf(0) : Integer.valueOf(1);
                RnrNoticeContentDTO rnrNoticeContentDTO = new RnrNoticeContentDTO();
                rnrNoticeContentDTO.setUuid(CuscStringUtils.generateUuid());
                rnrNoticeContentDTO.setNoticeConfigId(rnrNoticeConfigDTO.getUuid());
                rnrNoticeContentDTO.setNoticeSubject("");
                rnrNoticeContentDTO.setRnrBizzType(Integer.valueOf(bean.getRnrBizzType()));
                rnrNoticeContentDTO.setNoticeContent(parameters.toString());
                rnrNoticeContentDTO.setNoticeStatus(noticeStatus);
                rnrNoticeContentDTO.setCount(Integer.valueOf(1));
                rnrNoticeContentDTO.setCreator(bean.getOperator());
                this.rnrNoticeContentService.insert(rnrNoticeContentDTO);
                RnrNoticeContentLogDTO rnrNoticeContentLogDTO = new RnrNoticeContentLogDTO();
                rnrNoticeContentLogDTO.setUuid(CuscStringUtils.generateUuid());
                rnrNoticeContentLogDTO.setRnrBizzType(Integer.valueOf(bean.getRnrBizzType()));
                rnrNoticeContentLogDTO.setNoticeContentId(rnrNoticeContentDTO.getUuid());
                rnrNoticeContentLogDTO.setRequestTime(requestTime);
                rnrNoticeContentLogDTO.setResponseTime(responseTime);
                if (Objects.nonNull(ret)) {
                    rnrNoticeContentLogDTO.setResponseMsg(ret.getMsg());
                }
                rnrNoticeContentLogDTO.setIsSuccess(noticeStatus);
                rnrNoticeContentLogDTO.setCreator(bean.getOperator());
                this.rnrNoticeContentLogService.insert(rnrNoticeContentLogDTO);
            }
        }
        catch (Exception e) {
            log.error("RnrNoticeConsumer \u6d88\u8d39\u5f02\u5e38: data = {}", (Object)JSONObject.toJSONString((Object)bean), (Object)e);
        }
    }
}

