/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.notice.kafka;

import com.alibaba.fastjson.JSON;
import com.cusc.nirvana.user.rnr.mg.dto.MgCardNoticeDTO;
import com.cusc.nirvana.user.rnr.notice.service.NoticeHandler;
import com.cusc.nirvana.user.rnr.notice.service.NoticeHandlerContext;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
public class KfKRnrNoticeConsumer {
    private static final Logger log = LoggerFactory.getLogger(KfKRnrNoticeConsumer.class);
    @Autowired
    NoticeHandlerContext handlerContext;

    @KafkaListener(id="cusc-rnr-card-operation-group", topics={"cusc-rnr-card-operation-topic"})
    public void onMessage(ConsumerRecord<?, ?> record) {
        Optional<Object> kafkaMessage = Optional.ofNullable(record.value());
        MgCardNoticeDTO bean = null;
        if (kafkaMessage.isPresent()) {
            Object message = kafkaMessage.get();
            bean = (MgCardNoticeDTO)JSON.parseObject((String)message.toString(), MgCardNoticeDTO.class);
        }
        log.info("RnrNoticeConsumer onMessage: {}", (Object)JSON.toJSONString(bean));
        if (Objects.isNull(bean)) {
            return;
        }
        for (NoticeHandler noticeHandler : this.handlerContext.getHandlerList()) {
            noticeHandler.handleNotice(bean);
        }
    }
}

