/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.notice.kafka;

import com.alibaba.fastjson.JSON;
import com.cusc.nirvana.user.rnr.mg.constants.NoticeStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
public class KfKRnrBindExchangeConsumer {
    private static final Logger log = LoggerFactory.getLogger(KfKRnrBindExchangeConsumer.class);
    @Autowired
    IRnrOrderService orderService;
    @Autowired
    IMgRnrCardInfoService cardInfoService;

    @KafkaListener(id="cusc-rnr-card-operation-delay-group", topics={"cusc-rnr-card-operation-delay-topic"})
    public void onMessage(ConsumerRecord<?, ?> record) {
        Optional<Object> kafkaMessage = Optional.ofNullable(record.value());
        String message = "";
        if (kafkaMessage.isPresent()) {
            message = (String)kafkaMessage.get();
        }
        log.info("\u63a5\u6536\u5230\u5ef6\u8fdf\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message));
        RnrOrderDTO rnrOrderDTO = new RnrOrderDTO();
        rnrOrderDTO.setUuid(message);
        rnrOrderDTO = this.orderService.getByUuid(rnrOrderDTO);
        if (rnrOrderDTO != null && RnrOrderStatusEnum.notFinished((Integer)rnrOrderDTO.getOrderStatus())) {
            this.orderService.updateOrderStatus(Collections.singletonList(rnrOrderDTO.getUuid()), RnrOrderStatusEnum.CANCEL.getCode().intValue());
            this.cardInfoService.updateCardStatusByOrderId(rnrOrderDTO.getUuid(), NoticeStatusEnum.NONEED.getCode(), RnrStatus.RNR_FAIL.getCode());
        }
    }
}

