/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.notice.kafka;

import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@Configuration
public class KafkaConfig {
    @Value(value="${spring.kafka.bootstrap-servers}")
    private String server;
    @Value(value="${spring.kafka.producer.retries}")
    private String producerRetries;
    @Value(value="${spring.kafka.producer.sasl-jaas-config:}")
    private String kafkaProducerSASLJaasConfig;
    @Value(value="${spring.kafka.consumer.auto-offset-reset}")
    private String autoOffsetReset;
    @Value(value="${spring.kafka.consumer.enable-auto-commit}")
    private String autoCommit;
    @Value(value="${spring.kafka.consumer.auto-commit-interval}")
    private String autoCommitInterval;
    @Value(value="${spring.kafka.consumer.sasl-jaas-config:}")
    private String kafkaConsumerSASLJaasConfig;
    @Value(value="${spring.kafka.inner.security-protocol:}")
    private String kafkaSecurityProtocol;
    @Value(value="${spring.kafka.inner.sasl-mechanism:}")
    private String kafkaSASLMechanism;

    @Bean
    public ProducerFactory<String, String> producerFactory() {
        return new DefaultKafkaProducerFactory(this.producerConfigs());
    }

    @Bean
    public Map<String, Object> producerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.server);
        props.put("retries", this.producerRetries);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        if (!(CuscStringUtils.isEmpty((String)this.kafkaSecurityProtocol) || CuscStringUtils.isEmpty((String)this.kafkaSASLMechanism) || CuscStringUtils.isEmpty((String)this.kafkaProducerSASLJaasConfig))) {
            props.put("security.protocol", this.kafkaSecurityProtocol);
            props.put("sasl.mechanism", this.kafkaSASLMechanism);
            props.put("sasl.jaas.config", this.kafkaProducerSASLJaasConfig);
        }
        return props;
    }

    @Bean
    ConcurrentKafkaListenerContainerFactory<Integer, String> kafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        return factory;
    }

    @Bean
    public ConsumerFactory<Integer, String> consumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfigs());
    }

    @Bean
    public Map<String, Object> consumerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.server);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        props.put("enable.auto.commit", this.autoCommit);
        props.put("auto.commit.interval.ms", this.autoCommitInterval);
        props.put("auto.offset.reset", this.autoOffsetReset);
        if (!(CuscStringUtils.isEmpty((String)this.kafkaSecurityProtocol) || CuscStringUtils.isEmpty((String)this.kafkaSASLMechanism) || CuscStringUtils.isEmpty((String)this.kafkaConsumerSASLJaasConfig))) {
            props.put("security.protocol", this.kafkaSecurityProtocol);
            props.put("sasl.mechanism", this.kafkaSASLMechanism);
            props.put("sasl.jaas.config", this.kafkaConsumerSASLJaasConfig);
        }
        return props;
    }

    @Bean
    public KafkaTemplate<String, String> kafkaTemplate() {
        return new KafkaTemplate(this.producerFactory());
    }

    public String getServer() {
        return this.server;
    }

    public String getProducerRetries() {
        return this.producerRetries;
    }

    public String getKafkaProducerSASLJaasConfig() {
        return this.kafkaProducerSASLJaasConfig;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public String getAutoCommit() {
        return this.autoCommit;
    }

    public String getAutoCommitInterval() {
        return this.autoCommitInterval;
    }

    public String getKafkaConsumerSASLJaasConfig() {
        return this.kafkaConsumerSASLJaasConfig;
    }

    public String getKafkaSecurityProtocol() {
        return this.kafkaSecurityProtocol;
    }

    public String getKafkaSASLMechanism() {
        return this.kafkaSASLMechanism;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setProducerRetries(String producerRetries) {
        this.producerRetries = producerRetries;
    }

    public void setKafkaProducerSASLJaasConfig(String kafkaProducerSASLJaasConfig) {
        this.kafkaProducerSASLJaasConfig = kafkaProducerSASLJaasConfig;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public void setAutoCommit(String autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setAutoCommitInterval(String autoCommitInterval) {
        this.autoCommitInterval = autoCommitInterval;
    }

    public void setKafkaConsumerSASLJaasConfig(String kafkaConsumerSASLJaasConfig) {
        this.kafkaConsumerSASLJaasConfig = kafkaConsumerSASLJaasConfig;
    }

    public void setKafkaSecurityProtocol(String kafkaSecurityProtocol) {
        this.kafkaSecurityProtocol = kafkaSecurityProtocol;
    }

    public void setKafkaSASLMechanism(String kafkaSASLMechanism) {
        this.kafkaSASLMechanism = kafkaSASLMechanism;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConfig)) {
            return false;
        }
        KafkaConfig other = (KafkaConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$producerRetries = this.getProducerRetries();
        String other$producerRetries = other.getProducerRetries();
        if (this$producerRetries == null ? other$producerRetries != null : !this$producerRetries.equals(other$producerRetries)) {
            return false;
        }
        String this$kafkaProducerSASLJaasConfig = this.getKafkaProducerSASLJaasConfig();
        String other$kafkaProducerSASLJaasConfig = other.getKafkaProducerSASLJaasConfig();
        if (this$kafkaProducerSASLJaasConfig == null ? other$kafkaProducerSASLJaasConfig != null : !this$kafkaProducerSASLJaasConfig.equals(other$kafkaProducerSASLJaasConfig)) {
            return false;
        }
        String this$autoOffsetReset = this.getAutoOffsetReset();
        String other$autoOffsetReset = other.getAutoOffsetReset();
        if (this$autoOffsetReset == null ? other$autoOffsetReset != null : !this$autoOffsetReset.equals(other$autoOffsetReset)) {
            return false;
        }
        String this$autoCommit = this.getAutoCommit();
        String other$autoCommit = other.getAutoCommit();
        if (this$autoCommit == null ? other$autoCommit != null : !this$autoCommit.equals(other$autoCommit)) {
            return false;
        }
        String this$autoCommitInterval = this.getAutoCommitInterval();
        String other$autoCommitInterval = other.getAutoCommitInterval();
        if (this$autoCommitInterval == null ? other$autoCommitInterval != null : !this$autoCommitInterval.equals(other$autoCommitInterval)) {
            return false;
        }
        String this$kafkaConsumerSASLJaasConfig = this.getKafkaConsumerSASLJaasConfig();
        String other$kafkaConsumerSASLJaasConfig = other.getKafkaConsumerSASLJaasConfig();
        if (this$kafkaConsumerSASLJaasConfig == null ? other$kafkaConsumerSASLJaasConfig != null : !this$kafkaConsumerSASLJaasConfig.equals(other$kafkaConsumerSASLJaasConfig)) {
            return false;
        }
        String this$kafkaSecurityProtocol = this.getKafkaSecurityProtocol();
        String other$kafkaSecurityProtocol = other.getKafkaSecurityProtocol();
        if (this$kafkaSecurityProtocol == null ? other$kafkaSecurityProtocol != null : !this$kafkaSecurityProtocol.equals(other$kafkaSecurityProtocol)) {
            return false;
        }
        String this$kafkaSASLMechanism = this.getKafkaSASLMechanism();
        String other$kafkaSASLMechanism = other.getKafkaSASLMechanism();
        return !(this$kafkaSASLMechanism == null ? other$kafkaSASLMechanism != null : !this$kafkaSASLMechanism.equals(other$kafkaSASLMechanism));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $producerRetries = this.getProducerRetries();
        result = result * 59 + ($producerRetries == null ? 43 : $producerRetries.hashCode());
        String $kafkaProducerSASLJaasConfig = this.getKafkaProducerSASLJaasConfig();
        result = result * 59 + ($kafkaProducerSASLJaasConfig == null ? 43 : $kafkaProducerSASLJaasConfig.hashCode());
        String $autoOffsetReset = this.getAutoOffsetReset();
        result = result * 59 + ($autoOffsetReset == null ? 43 : $autoOffsetReset.hashCode());
        String $autoCommit = this.getAutoCommit();
        result = result * 59 + ($autoCommit == null ? 43 : $autoCommit.hashCode());
        String $autoCommitInterval = this.getAutoCommitInterval();
        result = result * 59 + ($autoCommitInterval == null ? 43 : $autoCommitInterval.hashCode());
        String $kafkaConsumerSASLJaasConfig = this.getKafkaConsumerSASLJaasConfig();
        result = result * 59 + ($kafkaConsumerSASLJaasConfig == null ? 43 : $kafkaConsumerSASLJaasConfig.hashCode());
        String $kafkaSecurityProtocol = this.getKafkaSecurityProtocol();
        result = result * 59 + ($kafkaSecurityProtocol == null ? 43 : $kafkaSecurityProtocol.hashCode());
        String $kafkaSASLMechanism = this.getKafkaSASLMechanism();
        result = result * 59 + ($kafkaSASLMechanism == null ? 43 : $kafkaSASLMechanism.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaConfig(server=" + this.getServer() + ", producerRetries=" + this.getProducerRetries() + ", kafkaProducerSASLJaasConfig=" + this.getKafkaProducerSASLJaasConfig() + ", autoOffsetReset=" + this.getAutoOffsetReset() + ", autoCommit=" + this.getAutoCommit() + ", autoCommitInterval=" + this.getAutoCommitInterval() + ", kafkaConsumerSASLJaasConfig=" + this.getKafkaConsumerSASLJaasConfig() + ", kafkaSecurityProtocol=" + this.getKafkaSecurityProtocol() + ", kafkaSASLMechanism=" + this.getKafkaSASLMechanism() + ")";
    }
}

