/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.notice.kafka;

import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cache.service.ISortSetService;
import com.cusc.nirvana.user.rnr.notice.kafka.ConsumeDelaySchedule;
import com.cusc.nirvana.user.rnr.notice.kafka.KafkaProduct;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

@Configuration
@EnableScheduling
public class ConsumeDelaySchedule {
    private static final Logger log = LoggerFactory.getLogger(ConsumeDelaySchedule.class);
    @Resource
    private CacheFactory cacheFactory;
    @Autowired
    private KafkaProduct kafkaProduct;
    @Autowired
    private ThreadPoolTaskScheduler taskScheduler;
    private ScheduledFuture<?> future;

    @PostConstruct
    public void StartCron() {
        try {
            String basetime = "*/3 * * * * * ";
            if (this.future == null) {
                this.future = this.taskScheduler.schedule((Runnable)new runnable(this, null), (Trigger)new CronTrigger(basetime));
            }
        }
        catch (Exception e) {
            log.error("\u5ef6\u8fdf\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    public void consume() {
        try {
            ISortSetService sortSetService = this.cacheFactory.getSortSetService();
            Map sortSetWithScore = sortSetService.getSortSetWithScore("CT:USER:cusc-rnr-card-operation-delay-topic", 1);
            sortSetWithScore.forEach((key, value) -> {
                if (value <= (double)System.currentTimeMillis()) {
                    try {
                        boolean result = this.kafkaProduct.sendMessage("cusc-rnr-card-operation-delay-topic", key);
                        if (result) {
                            sortSetService.delMembers("CT:USER:cusc-rnr-card-operation-delay-topic", new String[]{key});
                        }
                    }
                    catch (CacheException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39redis\u6d88\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }
}

