/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.util.crypt;

import com.cusc.nirvana.user.rnr.mg.util.crypt.HexUtil;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Sm4Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sm4Util.class);
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    public static final String ALGORITHM_NAME_CBC_PADDING = "SM4/CBC/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE = 128;

    private Sm4Util() {
    }

    public static byte[] generateKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        return Sm4Util.generateKey((int)128);
    }

    public static byte[] generateKey(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator kg = KeyGenerator.getInstance("SM4", "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    public static byte[] encryptEcbPaddingByte(byte[] key, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Sm4Util.generateEcbCipher((String)"SM4/ECB/PKCS5Padding", (int)1, (byte[])key);
        return cipher.doFinal(data);
    }

    public static String encryptEcbPadding(String key, String data) {
        return Sm4Util.encryptEcbPaddingHex((String)key, (String)data, (boolean)false, null);
    }

    public static String encryptEcbPaddingHex(String key, String data, boolean hexString, String charset) {
        if (CuscStringUtils.isEmpty((String)data)) {
            return null;
        }
        try {
            byte[] keyBytes = hexString ? HexUtil.hexStringToBytes((String)key) : key.getBytes();
            byte[] dataBytes = CuscStringUtils.isNotEmpty((String)charset) ? data.getBytes(charset) : data.getBytes(StandardCharsets.UTF_8);
            byte[] encrypted = Sm4Util.encryptEcbPaddingByte((byte[])keyBytes, (byte[])dataBytes);
            return Sm4Util.base64Encoder((byte[])encrypted);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.encryptEcbPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    public static byte[] decryptEcbPaddingByte(byte[] key, byte[] cipherText) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher cipher = Sm4Util.generateEcbCipher((String)"SM4/ECB/PKCS5Padding", (int)2, (byte[])key);
        return cipher.doFinal(cipherText);
    }

    public static String decryptEcbPadding(String key, String data) {
        return Sm4Util.decryptEcbPaddingHex((String)key, (String)data, (boolean)false, null);
    }

    public static String decryptEcbPaddingHex(String key, String data, boolean hexString, String charset) {
        if (CuscStringUtils.isEmpty((String)data)) {
            return null;
        }
        try {
            byte[] keyBytes = hexString ? HexUtil.hexStringToBytes((String)key) : key.getBytes();
            byte[] decrypted = Sm4Util.decryptEcbPaddingByte((byte[])keyBytes, (byte[])Sm4Util.base64Decoder((String)data));
            if (CuscStringUtils.isNotEmpty((String)charset)) {
                return new String(decrypted, charset);
            }
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.decryptEcbPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    public static byte[] encryptCbcPaddingByte(byte[] key, byte[] iv, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        Cipher cipher = Sm4Util.generateCbcCipher((String)"SM4/CBC/PKCS5Padding", (int)1, (byte[])key, (byte[])iv);
        return cipher.doFinal(data);
    }

    public static String encryptCbcPadding(String key, String data, String iv) {
        return Sm4Util.encryptCbcPaddingHex((String)key, (String)data, (String)iv, (boolean)false, null);
    }

    public static String encryptCbcPaddingHex(String key, String data, String iv, boolean hexString, String charset) {
        if (CuscStringUtils.isEmpty((String)data)) {
            return null;
        }
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            if (hexString) {
                keyBytes = HexUtil.hexStringToBytes((String)key);
                ivBytes = HexUtil.hexStringToBytes((String)iv);
            } else {
                keyBytes = key.getBytes();
                ivBytes = iv.getBytes();
            }
            byte[] dataBytes = CuscStringUtils.isNotEmpty((String)charset) ? data.getBytes(charset) : data.getBytes(StandardCharsets.UTF_8);
            byte[] encrypted = Sm4Util.encryptCbcPaddingByte((byte[])keyBytes, (byte[])ivBytes, (byte[])dataBytes);
            return Sm4Util.base64Encoder((byte[])encrypted);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.encryptCbcPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    public static byte[] decryptCbcPaddingByte(byte[] key, byte[] iv, byte[] cipherText) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        Cipher cipher = Sm4Util.generateCbcCipher((String)"SM4/CBC/PKCS5Padding", (int)2, (byte[])key, (byte[])iv);
        return cipher.doFinal(cipherText);
    }

    public static String decryptCbcPadding(String key, String data, String iv) {
        return Sm4Util.decryptCbcPaddingHex((String)key, (String)data, (String)iv, (boolean)false, null);
    }

    public static String decryptCbcPaddingHex(String key, String data, String iv, boolean hexString, String charset) {
        if (CuscStringUtils.isEmpty((String)data)) {
            return null;
        }
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            if (hexString) {
                keyBytes = HexUtil.hexStringToBytes((String)key);
                ivBytes = HexUtil.hexStringToBytes((String)iv);
            } else {
                keyBytes = key.getBytes();
                ivBytes = iv.getBytes();
            }
            byte[] decrypted = Sm4Util.decryptCbcPaddingByte((byte[])keyBytes, (byte[])ivBytes, (byte[])Sm4Util.base64Decoder((String)data));
            if (CuscStringUtils.isNotEmpty((String)charset)) {
                return new String(decrypted, charset);
            }
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.decryptCbcPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, "SM4");
        cipher.init(mode, sm4Key);
        return cipher;
    }

    private static Cipher generateCbcCipher(String algorithmName, int mode, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, "SM4");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(mode, (Key)sm4Key, ivParameterSpec);
        return cipher;
    }

    private static String base64Encoder(byte[] encrypted) {
        return Base64.getEncoder().encodeToString(encrypted);
    }

    private static byte[] base64Decoder(String encrypted) throws IOException {
        return Base64.getDecoder().decode(encrypted);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

