/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.util;

import com.cusc.nirvana.user.util.CuscStringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);
    public static String yyyyMM = "yyyyMM";
    public static String yyyyMMdd = "yyyyMMdd";
    public static String yyyyMMddHHmm = "yyyyMMddHHmm";
    public static String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static String yyyyMMddHHmmssS = "yyyyMMddHHmmssS";
    public static String yyyyMMddHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static String dayChiness = "yyyy\u5e74MM\u6708dd\u65e5";
    public static String dayChinessTwo = "yyyy\u5e74MM\u6708dd\u65e5HH:mm";
    public static String yyyy_MM_dd = "yyyy-MM-dd";
    public static String yyyy_MM_dd_HH_mm = "yyyy-MM-dd HH:mm";
    public static String yyyy_MM_dd_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
    public static String yyyy_MM_dd_HH_mm_ss_S = "yyyy-MM-dd HH:mm:ss.S";
    public static String YYYYsMMsDD = "yyyy/MM/dd";
    public static String MMsDDsYYYY = "MM/dd/yyyy";
    public static String DDsMMsYYYY = "dd/MM/yyyy";
    public static String MM_dd = "MM-dd";
    public static String HH_mm = "HH:mm";
    public static String hh_mm = "hh:mm";
    public static String HHmm = "HHmm";
    public static String hhmm = "hhmm";
    public static String ddMMM = "ddMMM";
    public static String ddMMMyy = "ddMMMyy";
    public static String ddMMMyyyy = "ddMMMyyyy";
    public static String BEFORE = "-";
    public static String AFTER = "+";

    public static int compareDate(Date date1, Date date2) {
        return date1.compareTo(date2);
    }

    public static int daysBetween(Date beginDate, Date endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            beginDate = sdf.parse(sdf.format(beginDate));
            endDate = sdf.parse(sdf.format(endDate));
            long time1 = beginDate.getTime();
            long time2 = endDate.getTime();
            long between_days = (time2 - time1) / 86400000L;
            return Integer.parseInt(String.valueOf(between_days));
        }
        catch (ParseException e) {
            LOGGER.error("DateUtil.daysBetween error ! ", (Throwable)e);
            return -1;
        }
    }

    public static Date parseDate(String dateStr, String format) {
        if (CuscStringUtils.isEmpty((String)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            LOGGER.error("DateUtil.parseDate error ! ", (Throwable)e);
            return null;
        }
    }

    public static Calendar getCalendar(Date date) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setFirstDayOfWeek(2);
            calendar.setTime(date);
            return calendar;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Calendar getCalendarByDateStr(String dateString, String formater) throws Exception {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new SimpleDateFormat(formater).parse(dateString));
            return calendar;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getIntervalDate(Date date, String type, int interval) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (BEFORE.equals(type)) {
            cal.add(5, -interval);
        }
        if (AFTER.equals(type)) {
            cal.add(5, interval);
        }
        return cal.getTime();
    }

    public static String getIntervalDateStr(Date date, String formater, String type, int interval) {
        Date lastDate = DateUtil.getIntervalDate((Date)date, (String)type, (int)interval);
        return DateUtil.toString((Date)lastDate, (String)formater);
    }

    public static String getIntervalMonthStr(Date date, String formater, String type, int interval) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (BEFORE.equals(type)) {
            cal.add(2, -interval);
        }
        if (AFTER.equals(type)) {
            cal.add(2, interval);
        }
        Date lastDate = cal.getTime();
        return DateUtil.toString((Date)lastDate, (String)formater);
    }

    public static Date getSpanTime(Date depTime, Date arrTime) {
        Date spanTime = new Date();
        spanTime.setTime(arrTime.getTime() - depTime.getTime() - 28800000L);
        return spanTime;
    }

    public static Date getSpanTime(String depTimeStr, String arrTimeStr) {
        Date depTime = DateUtil.toDate((String)depTimeStr, (String)HH_mm);
        Date arrTime = DateUtil.toDate((String)arrTimeStr, (String)HH_mm);
        Date spanTime = new Date();
        spanTime.setTime(arrTime.getTime() - depTime.getTime() - 28800000L);
        return spanTime;
    }

    public static long getSpanSeconds(Date startTime, Date endTime) {
        return endTime.getTime() - startTime.getTime();
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getCurrentMonth() {
        return Calendar.getInstance().get(2);
    }

    public static int getCurrentDay() {
        return Calendar.getInstance().get(5);
    }

    public static int getCurrentHour12() {
        return Calendar.getInstance().get(10);
    }

    public static int getCurrentHour24() {
        return Calendar.getInstance().get(11);
    }

    public static int getCurrentMinute() {
        return Calendar.getInstance().get(12);
    }

    public static int getCurrentSecond() {
        return Calendar.getInstance().get(13);
    }

    public static Date toDate(String dateStr, String formater) {
        if (!StringUtils.hasText((String)dateStr)) {
            return null;
        }
        try {
            if (StringUtils.hasText((String)formater)) {
                return new SimpleDateFormat(formater).parse(dateStr);
            }
            return new SimpleDateFormat(yyyy_MM_dd).parse(dateStr);
        }
        catch (Exception pe) {
            return null;
        }
    }

    public static Date toDate(Date oldDate, String oldFormater, String newFormater) {
        if (oldDate == null) {
            return null;
        }
        try {
            String oldDateString = DateUtil.toString((Date)oldDate, (String)oldFormater);
            return DateUtil.toDate((String)oldDateString, (String)newFormater);
        }
        catch (Exception pe) {
            return null;
        }
    }

    public static Date toDate(String dateStr, String oriFormater, Locale oriLocale) {
        if (oriLocale == null) {
            return DateUtil.toDate((String)dateStr, (String)oriFormater);
        }
        if (!StringUtils.hasText((String)dateStr)) {
            return null;
        }
        try {
            if (StringUtils.hasText((String)oriFormater)) {
                return new SimpleDateFormat(oriFormater, oriLocale).parse(dateStr);
            }
            return new SimpleDateFormat(yyyy_MM_dd, oriLocale).parse(dateStr);
        }
        catch (Exception pe) {
            return null;
        }
    }

    public static String toString(Date date, String dstFormater) {
        try {
            if (!StringUtils.hasText((String)dstFormater)) {
                return new SimpleDateFormat("yyyy-MM-dd").format(date);
            }
            return new SimpleDateFormat(dstFormater).format(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toString(Date date, String dstFormater, Locale dstLocale) {
        try {
            if (!StringUtils.hasText((String)dstFormater)) {
                dstFormater = ddMMMyy;
            }
            if (dstLocale == null) {
                return new SimpleDateFormat(dstFormater).format(date).toUpperCase();
            }
            return new SimpleDateFormat(dstFormater, dstLocale).format(date).toUpperCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toString(String oriDateStr, String oriFormater, String dstFormater) {
        try {
            if (!StringUtils.hasText((String)oriDateStr)) {
                return "";
            }
            if (!StringUtils.hasText((String)oriFormater)) {
                oriFormater = yyyy_MM_dd;
            }
            Date date = DateUtil.toDate((String)oriDateStr, (String)oriFormater);
            if (!StringUtils.hasText((String)dstFormater)) {
                dstFormater = yyyy_MM_dd;
            }
            return new SimpleDateFormat(dstFormater).format(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toString(String oriDateStr, String oriFormater, Locale oriLocale, String dstFormater, Locale dstLocale) {
        try {
            if (!StringUtils.hasText((String)oriDateStr)) {
                return "";
            }
            if (!StringUtils.hasText((String)oriFormater)) {
                oriFormater = yyyy_MM_dd;
            }
            Date date = DateUtil.toDate((String)oriDateStr, (String)oriFormater, (Locale)oriLocale);
            if (!StringUtils.hasText((String)dstFormater)) {
                dstFormater = ddMMMyy;
            }
            if (dstLocale == null) {
                return new SimpleDateFormat(dstFormater).format(date).toUpperCase();
            }
            return new SimpleDateFormat(dstFormater, dstLocale).format(date).toUpperCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatDate(String value, String oldStyle, String newStyle) {
        if (!StringUtils.hasText((String)value)) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(oldStyle);
        SimpleDateFormat df1 = new SimpleDateFormat(newStyle);
        try {
            return df1.format(df.parse(value));
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static String getChineseDate(Date d) {
        if (d == null) {
            return null;
        }
        String dtrDate = new SimpleDateFormat(yyyyMMdd).format(d);
        return dtrDate.substring(0, 4) + "\u5e74" + Integer.parseInt(dtrDate.substring(4, 6)) + "\u6708" + Integer.parseInt(dtrDate.substring(6, 8)) + "\u65e5";
    }

    public static String getChineseYyyyMmDd(Date d) {
        if (d == null) {
            return null;
        }
        String dtrDate = new SimpleDateFormat(yyyyMMdd).format(d);
        return dtrDate.substring(0, 4) + "\u5e74" + dtrDate.substring(4, 6) + "\u6708" + dtrDate.substring(6, 8) + "\u65e5";
    }

    public static String getChineseDateMMddHHss(Date d) {
        if (d == null) {
            return null;
        }
        String dtrDate = DateUtil.toString((Date)d, (String)yyyy_MM_dd_HH_mm);
        return dtrDate.substring(5, 7) + "\u6708" + dtrDate.substring(8, 10) + "\u65e5" + dtrDate.substring(11);
    }

    public static String getCnDayNameOfWeek(Date date) {
        String[] weeks = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar calendar = DateUtil.getCalendar((Date)date);
        int day = calendar.get(7);
        return weeks[day - 1];
    }

    public static String getCnDayNameOfWeek(String strDate) {
        Date date = DateUtil.toDate((String)strDate, null);
        return DateUtil.getCnDayNameOfWeek((Date)date);
    }

    public static String getNumberByEnMonth(String enMonthString) {
        String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        for (int i = 0; i < months.length; ++i) {
            if (!months[i].equalsIgnoreCase(enMonthString)) continue;
            if (i < 9) {
                return "0" + (i + 1);
            }
            return Integer.toString(i + 1);
        }
        return null;
    }

    public static Date getIntervalDate(Date date, String type, String intervalString) {
        try {
            int interval = Integer.valueOf(intervalString.substring(0, intervalString.length() - 1));
            String dayOrMonth = intervalString.substring(intervalString.length() - 1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if ("S".equals(dayOrMonth.toUpperCase())) {
                if (BEFORE.equals(type)) {
                    cal.add(13, -interval);
                }
                if (AFTER.equals(type)) {
                    cal.add(13, interval);
                }
            } else if ("I".equals(dayOrMonth.toUpperCase())) {
                if (BEFORE.equals(type)) {
                    cal.add(12, -interval);
                }
                if (AFTER.equals(type)) {
                    cal.add(12, interval);
                }
            } else if ("H".equals(dayOrMonth.toUpperCase())) {
                if (BEFORE.equals(type)) {
                    cal.add(10, -interval);
                }
                if (AFTER.equals(type)) {
                    cal.add(10, interval);
                }
            } else if ("D".equals(dayOrMonth.toUpperCase())) {
                if (BEFORE.equals(type)) {
                    cal.add(5, -interval);
                }
                if (AFTER.equals(type)) {
                    cal.add(5, interval);
                }
            } else if ("M".equals(dayOrMonth.toUpperCase())) {
                if (BEFORE.equals(type)) {
                    cal.add(2, -interval);
                }
                if (AFTER.equals(type)) {
                    cal.add(2, interval);
                }
            } else if ("Y".equals(dayOrMonth.toUpperCase())) {
                if (BEFORE.equals(type)) {
                    cal.add(1, -interval);
                }
                if (AFTER.equals(type)) {
                    cal.add(1, interval);
                }
            }
            return cal.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getIntervalDate(String dateStr, String type, String intervalString) {
        Date date = DateUtil.toDate((String)dateStr, (String)yyyy_MM_dd);
        return DateUtil.getIntervalDate((Date)date, (String)type, (String)intervalString);
    }

    public static String getDayofTheWeek(Date date, Locale locale) {
        if (locale != null && locale.toString().startsWith(Locale.UK.toString())) {
            String[] weeks = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
            Calendar calendar = DateUtil.getCalendar((Date)date);
            int day = calendar.get(7);
            return weeks[day - 1];
        }
        return DateUtil.getCnDayNameOfWeek((Date)date);
    }

    public static String getDate(Date date, Locale locale) {
        if (locale != null && locale.toString().startsWith(Locale.UK.toString())) {
            return DateUtil.toString((Date)date, (String)MM_dd);
        }
        return DateUtil.getChineseDate((Date)date).substring(5);
    }

    public static String getFormatDateForUpdateTime(Date date, Locale locale) {
        if (locale != null && locale.toString().startsWith(Locale.UK.toString())) {
            return DateUtil.toString((Date)date, (String)yyyy_MM_dd_HH_mm);
        }
        return DateUtil.getChineseDateMMddHHss((Date)date);
    }

    public static XMLGregorianCalendar date2XMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        XMLGregorianCalendar xmlCa = null;
        try {
            xmlCa = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        }
        catch (Exception e) {
            log.error("xml date error", (Throwable)e);
        }
        return xmlCa;
    }

    public static boolean isValidDate(String strDate) {
        SimpleDateFormat parser = new SimpleDateFormat(yyyyMMdd);
        parser.setLenient(false);
        try {
            parser.parse(strDate);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

