/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.converter.SimFileHistoryConverter;
import com.cusc.nirvana.user.rnr.mg.dao.SimFileHistoryDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.SimFileHistoryPO;
import com.cusc.nirvana.user.rnr.mg.dto.SimFileHistoryDTO;
import com.cusc.nirvana.user.rnr.mg.dto.SimFileHistoryQueryDTO;
import com.cusc.nirvana.user.rnr.mg.service.ISimFileHistoryService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.springframework.stereotype.Service;

@Service
public class SimFileHistoryServiceImpl
extends ServiceImpl<SimFileHistoryDao, SimFileHistoryPO>
implements ISimFileHistoryService {
    public SimFileHistoryDTO getByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        SimFileHistoryPO historyPO = (SimFileHistoryPO)this.getOne((Wrapper)queryWrapper);
        return historyPO == null ? null : SimFileHistoryConverter.INSTANCE.poToDto(historyPO);
    }

    public PageResult<SimFileHistoryDTO> queryByPage(SimFileHistoryQueryDTO queryDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"org_uuid", (Object)queryDTO.getOrgUuid());
        queryWrapper.eq((Object)"file_type", (Object)queryDTO.getFileType());
        queryWrapper.gt(queryDTO.getStartCreateTime() != null, (Object)"create_time", (Object)queryDTO.getStartCreateTime());
        queryWrapper.lt(queryDTO.getEndCreateTime() != null, (Object)"create_time", (Object)queryDTO.getEndCreateTime());
        if (queryDTO.getStatus() != null) {
            if (queryDTO.getStatus() != 2) {
                queryWrapper.eq((Object)"status", (Object)queryDTO.getStatus());
                queryWrapper.eq((Object)"error_count", (Object)0);
            } else {
                queryWrapper.gt((Object)"error_count", (Object)0);
            }
        }
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        Page historyPOPage = (Page)this.page((IPage)new Page((long)queryDTO.getCurrPage().intValue(), (long)queryDTO.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)historyPOPage, SimFileHistoryDTO.class);
    }

    public SimFileHistoryDTO insert(SimFileHistoryDTO historyDTO) {
        historyDTO.setUuid(CuscStringUtils.generateUuid());
        if (historyDTO.getErrorCount() > 0) {
            historyDTO.setStatus(Integer.valueOf(2));
        }
        SimFileHistoryPO simFileHistoryPO = SimFileHistoryConverter.INSTANCE.dtoToPo(historyDTO);
        this.save((Object)simFileHistoryPO);
        return historyDTO;
    }

    public SimFileHistoryDTO update(SimFileHistoryDTO historyDTO) {
        SimFileHistoryDTO bean = this.getByUuid(historyDTO.getUuid());
        if (bean == null) {
            return null;
        }
        historyDTO.setId(bean.getId());
        if (historyDTO.getErrorCount() > 0) {
            historyDTO.setStatus(Integer.valueOf(2));
        }
        SimFileHistoryPO simFileHistoryPO = SimFileHistoryConverter.INSTANCE.dtoToPo(historyDTO);
        this.updateById((Object)simFileHistoryPO);
        return historyDTO;
    }

    public boolean deleteById(String orgUuid, String uuid) {
        SimFileHistoryDTO historyDTO = this.getByUuid(uuid);
        if (historyDTO == null || !historyDTO.getOrgUuid().equals(orgUuid)) {
            return false;
        }
        historyDTO.setIsDelete(Integer.valueOf(1));
        return this.updateById((Object)SimFileHistoryConverter.INSTANCE.dtoToPo(historyDTO));
    }
}

