/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.alibaba.fastjson.JSON;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.common.constants.ResponseCode;
import com.cusc.nirvana.user.rnr.mg.constants.RnrBizzTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrCardInfoConverter;
import com.cusc.nirvana.user.rnr.mg.dto.MgCardNoticeDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrUnbindDTO;
import com.cusc.nirvana.user.rnr.mg.dto.VehicleUnbindDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardNoticeService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IProjectService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrRelationService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrUnboundService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RnrUnboundServiceImpl
implements IRnrUnboundService {
    private static final Logger log = LoggerFactory.getLogger(RnrUnboundServiceImpl.class);
    @Autowired
    private IMgRnrInfoService rnrInfoService;
    @Autowired
    private IMgRnrCardInfoService rnrCardInfoService;
    @Autowired
    private IRnrOrderService orderService;
    @Autowired
    @Lazy
    private IMgRnrCardNoticeService cardNoticeService;
    @Autowired
    private IProjectService projectService;
    @Autowired
    private IRnrRelationService relationService;

    @Transactional
    public Response rnrUnbound(RnrUnbindDTO bean) {
        if (StringUtils.isBlank((CharSequence)bean.getIccid())) {
            return Response.createError((String)ResponseCode.ICCID_NOT_NULL.getMsg(), (Integer)ResponseCode.ICCID_NOT_NULL.getCode());
        }
        ArrayList cardInfoDTOS = new ArrayList();
        ArrayList noticeDTOS = new ArrayList();
        Response response = this.checkCardAndRnrInfo(bean, cardInfoDTOS, noticeDTOS);
        if (!response.isSuccess().booleanValue()) {
            return response;
        }
        if (noticeDTOS.isEmpty()) {
            return Response.createError((String)ResponseCode.ICCID_RNR_INFO_NOT_MATCHED.getMsg(), (Integer)ResponseCode.ICCID_RNR_INFO_NOT_MATCHED.getCode());
        }
        List uuids = cardInfoDTOS.stream().map(MgRnrCardInfoDTO::getUuid).collect(Collectors.toList());
        this.rnrCardInfoService.unboundCardBatch(uuids, RnrStatus.UNBOUND);
        this.cardNoticeService.sendCardNotice(noticeDTOS);
        return Response.createSuccess();
    }

    @Transactional
    public Response batchUnbound(VehicleUnbindDTO bean) {
        ArrayList<MgCardNoticeDTO> mqList;
        log.info("\u8f66\u4f01\u5b9e\u540d\u89e3\u7ed1:{}", (Object)JSON.toJSONString((Object)bean));
        Response response = this.relationService.saveRnrRelation((RnrRelationDTO)bean);
        if (response.isSuccess().booleanValue()) {
            List cardIds = bean.getCardIds();
            this.rnrCardInfoService.unboundCardBatch(cardIds, RnrStatus.UNBOUND);
            this.orderService.updateOrderStatus(Collections.singletonList(bean.getOrder().getUuid()), RnrOrderStatusEnum.PASS.getCode().intValue());
            mqList = new ArrayList<MgCardNoticeDTO>();
            for (int i = 0; i < bean.getCardList().size(); ++i) {
                MgRnrCardInfoDTO mgRnrCardInfoDTO = (MgRnrCardInfoDTO)bean.getCardList().get(i);
                MgCardNoticeDTO mqDTO = new MgCardNoticeDTO();
                mqDTO.setVin(mgRnrCardInfoDTO.getIotId());
                mqDTO.setRnrBizzType(RnrBizzTypeEnum.Unbound.getCode().intValue());
                mqDTO.setOrderId(bean.getOrder().getUuid());
                mqDTO.setIccid(mgRnrCardInfoDTO.getIccid());
                mqList.add(mqDTO);
            }
        } else {
            return response;
        }
        this.cardNoticeService.sendCardNotice(mqList);
        return Response.createSuccess();
    }

    public Response secondHandUnBound(RnrRelationDTO bean) {
        return this.relationService.saveRnrRelation(bean);
    }

    private Response checkCardAndRnrInfo(RnrUnbindDTO bean, List<MgRnrCardInfoDTO> cardInfoDTOS, List<MgCardNoticeDTO> noticeDTOS) {
        MgRnrCardInfoDTO parm = new MgRnrCardInfoDTO();
        parm.setIccid(bean.getIccid());
        List mgRnrCardInfoDTOS = this.rnrCardInfoService.getListByIccid(parm);
        for (MgRnrCardInfoDTO cardInfoDTO : mgRnrCardInfoDTOS) {
            String rnrId = cardInfoDTO.getRnrId();
            MgRnrInfoDTO mgRnrInfoDTO = new MgRnrInfoDTO();
            mgRnrInfoDTO.setUuid(rnrId);
            mgRnrInfoDTO = this.rnrInfoService.getByUuid(mgRnrInfoDTO);
            if (cardInfoDTO.getRnrStatus().intValue() != RnrStatus.RNR.getCode() || !StringUtils.equals((CharSequence)mgRnrInfoDTO.getFullName(), (CharSequence)bean.getFullName()) || !StringUtils.equals((CharSequence)mgRnrInfoDTO.getCertNumber(), (CharSequence)bean.getCertNumber()) || !StringUtils.equals((CharSequence)mgRnrInfoDTO.getCertType(), (CharSequence)bean.getCertType())) continue;
            cardInfoDTOS.add(cardInfoDTO);
            MgCardNoticeDTO mgCardNoticeDTO = MgRnrCardInfoConverter.INSTANCE.unboundDTOtoNoticeDTO(bean);
            mgCardNoticeDTO.setRnrBizzType(RnrBizzTypeEnum.Unbound.getCode().intValue());
            mgCardNoticeDTO.setOrderId(cardInfoDTO.getOrderId());
            noticeDTOS.add(mgCardNoticeDTO);
        }
        return Response.createSuccess();
    }
}

