/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.cusc.nirvana.user.rnr.mg.constants.NoticeStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.service.ICiamService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardNoticeService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrResultProcessService;
import com.cusc.nirvana.user.rnr.mg.util.RnrOrderUtil;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class RnrResultProcessServiceImpl
implements IRnrResultProcessService {
    private static final Logger log = LoggerFactory.getLogger(RnrResultProcessServiceImpl.class);
    @Resource
    private IRnrOrderService orderService;
    @Resource
    @Lazy
    private IMgRnrCardNoticeService cardNoticeService;
    @Resource
    private IMgRnrInfoService mgRnrInfoService;
    @Resource
    private IMgRnrCardInfoService cardInfoService;
    @Autowired
    private ICiamService ciamService;

    public void processRnrResult(String orderId, String rnrId, RnrOrderStatusEnum statusEnum) {
        this.saveStatus(orderId, rnrId, statusEnum);
        if (statusEnum == RnrOrderStatusEnum.PASS) {
            this.saveUser(orderId, rnrId);
            log.info("\u5f00\u59cb\u53d1\u9001\u5b9e\u540d\u6210\u529fmq\uff0corder:{}", (Object)orderId);
            this.cardNoticeService.sendCardNoticeByOrderId(orderId);
        }
    }

    private void saveUser(String orderId, String rnrId) {
        MgRnrInfoDTO mgRnrInfoDTO = new MgRnrInfoDTO();
        mgRnrInfoDTO.setUuid(rnrId);
        mgRnrInfoDTO = this.mgRnrInfoService.getByUuid(mgRnrInfoDTO);
        RnrOrderDTO rnrOrderDTO = new RnrOrderDTO();
        rnrOrderDTO.setUuid(orderId);
        rnrOrderDTO = this.orderService.getByUuid(rnrOrderDTO);
        if (mgRnrInfoDTO != null && rnrOrderDTO != null && RnrOrderUtil.needCreateUser((MgRnrInfoDTO)mgRnrInfoDTO, (RnrOrderDTO)rnrOrderDTO)) {
            this.ciamService.createUser(mgRnrInfoDTO);
        }
    }

    private void saveStatus(String orderId, String rnrId, RnrOrderStatusEnum statusEnum) {
        this.orderService.updateOrderStatus(Collections.singletonList(orderId), statusEnum.getCode().intValue());
        if (statusEnum == RnrOrderStatusEnum.PASS) {
            this.mgRnrInfoService.updateRnrStatus(rnrId, RnrStatus.RNR);
            this.cardInfoService.updateCardStatusByOrderId(orderId, NoticeStatusEnum.NEED.getCode(), RnrStatus.RNR.getCode());
        } else {
            this.mgRnrInfoService.updateRnrStatus(rnrId, RnrStatus.RNR_FAIL);
            this.cardInfoService.updateCardStatusByOrderId(orderId, NoticeStatusEnum.NONEED.getCode(), RnrStatus.RNR_FAIL.getCode());
        }
    }
}

