/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.alibaba.fastjson.JSON;
import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cache.redis.util.FastJsonUtils;
import com.cusc.nirvana.common.loader.CollectionUtils;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.rnr.common.constants.RedisConstant;
import com.cusc.nirvana.user.rnr.common.constants.ResponseCode;
import com.cusc.nirvana.user.rnr.mg.constants.NoticeStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.PassCodeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOptLogBizTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOptLogOptTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOptLogSubTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderAuditTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderType;
import com.cusc.nirvana.user.rnr.mg.constants.RnrResponseCode;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrCardInfoConverter;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrCardInfoPO;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrOperationLogPO;
import com.cusc.nirvana.user.rnr.mg.dto.InfoLogCommentDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgCardNoticeDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCompanyInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrFileDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrLiaisonInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import com.cusc.nirvana.user.rnr.mg.service.ICiamService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardNoticeService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCompanyInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrFileService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrLiaisonInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrOperationLogService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrTagService;
import com.cusc.nirvana.user.rnr.mg.service.IProjectService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrRelationService;
import com.cusc.nirvana.user.rnr.mg.util.RnrOrderUtil;
import com.cusc.nirvana.user.rnr.mg.util.SpringValidationUtil;
import com.cusc.nirvana.user.rnr.mg.validation.group.SaveRelation;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.DateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.ConstraintViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RnrRelationServiceImpl
implements IRnrRelationService {
    private static final Logger log = LoggerFactory.getLogger(RnrRelationServiceImpl.class);
    @Autowired
    private IRnrOrderService rnrOrderService;
    @Autowired
    private IMgRnrInfoService rnrInfoService;
    @Autowired
    private IMgRnrCardInfoService rnrCardInfoService;
    @Autowired
    private IMgRnrCompanyInfoService rnrCompanyInfoService;
    @Autowired
    private IMgRnrTagService rnrTagService;
    @Autowired
    private IMgRnrLiaisonInfoService rnrLiaisonInfoService;
    @Autowired
    private IMgRnrFileService rnrFileService;
    @Resource
    private CacheFactory cacheFactory;
    @Autowired
    private IMgRnrOperationLogService rnrOperationLogService;
    @Autowired
    @Lazy
    private IMgRnrCardNoticeService cardNoticeService;
    @Autowired
    private IProjectService projectService;
    @Autowired
    private IMgRnrCompanyInfoService mgRnrCompanyInfoService;
    @Autowired
    private ICiamService ciamService;

    @Transactional
    public Response saveRnrRelation(RnrRelationDTO bean) {
        log.info("Mg realtionInfo:" + JSON.toJSONString((Object)bean));
        if (CollectionUtils.isEmpty((Collection)bean.getCardList())) {
            return Response.createError((String)ResponseCode.ICCID_NOT_NULL.getMsg(), (Integer)ResponseCode.ICCID_NOT_NULL.getCode());
        }
        MgRnrInfoDTO info = bean.getInfo();
        RnrOrderDTO order = bean.getOrder();
        order.setRnrId(info.getUuid());
        order.setFinalApproveTime(new Date(System.currentTimeMillis() + DateUtils.stringHourToMills((String)"4")));
        if (order.isAutoRnr()) {
            order.setUpdatedCode(PassCodeEnum.AUTO_SUCC.getCode());
            if (order.getOrderType().intValue() == RnrOrderType.REBINDING.getCode().intValue()) {
                order.setOldOrderStatus(RnrOrderStatusEnum.PASS.getCode());
            }
            order.setAuditType(RnrOrderAuditTypeEnum.AUTO.getCode());
        }
        InfoLogCommentDTO comment = new InfoLogCommentDTO();
        comment.setUserId(info.getUuid());
        comment.setLang(LocaleContextHolder.getLocale().toString());
        String logComment = FastJsonUtils.convertObjectToJSON((Object)comment);
        ArrayList<MgRnrCardInfoPO> cardPOList = new ArrayList<MgRnrCardInfoPO>();
        ArrayList<MgRnrOperationLogPO> cardLogList = new ArrayList<MgRnrOperationLogPO>();
        ArrayList<MgCardNoticeDTO> mqList = new ArrayList<MgCardNoticeDTO>();
        for (MgRnrCardInfoDTO cardDTO : bean.getCardList()) {
            cardDTO.setUuid(CuscStringUtils.generateUuid());
            cardDTO.setRnrId(info.getUuid());
            cardDTO.setTenantNo(info.getTenantNo());
            cardDTO.setRoutingKey(info.getRoutingKey());
            cardDTO.setNoticeStatus(Integer.valueOf(NoticeStatusEnum.NONEED.getCode()));
            cardDTO.setOrderId(order.getUuid());
            MgRnrOperationLogPO rnrOptLog = new MgRnrOperationLogPO();
            rnrOptLog.setUuid(CuscStringUtils.generateUuid());
            rnrOptLog.setBizType(Integer.valueOf(RnrOptLogBizTypeEnum.CARD.getCode()));
            rnrOptLog.setBizUuid(cardDTO.getUuid());
            rnrOptLog.setOptType(RnrOptLogOptTypeEnum.OPERATE_RNR.getCode());
            rnrOptLog.setOptSubType(order.getAuditType().intValue() == RnrOrderAuditTypeEnum.AUTO.getCode().intValue() ? RnrOptLogSubTypeEnum.AUTO_ACCESS_OPERATE.getCode() : RnrOptLogSubTypeEnum.RNR_SHIFT_TO_ARTIFICIAL.getCode());
            rnrOptLog.setOptTime(new Date());
            rnrOptLog.setContent(logComment);
            rnrOptLog.setIsBatchOrder(order.getIsBatchOrder());
            rnrOptLog.setSource(order.getOrderSource());
            rnrOptLog.setSerialNumber(order.getSerialNumber());
            rnrOptLog.setCreator(info.getCreator());
            rnrOptLog.setTenantNo(order.getTenantNo());
            cardLogList.add(rnrOptLog);
            if (!order.getSendWorkOrder().booleanValue() && RnrOrderStatusEnum.PASS.getCode().equals(bean.getOrder().getOrderStatus())) {
                cardDTO.setNoticeStatus(Integer.valueOf(NoticeStatusEnum.NEED.getCode()));
                cardDTO.setRnrStatus(Integer.valueOf(RnrOrderUtil.orderTypeToRnrStatus((int)order.getOrderType()).getCode()));
                MgCardNoticeDTO mqDTO = new MgCardNoticeDTO();
                mqDTO.setVin(cardDTO.getIotId());
                mqDTO.setRnrBizzType(RnrOrderUtil.orderTypeToNoticeType((int)order.getOrderType()).getCode().intValue());
                mqDTO.setOrderId(cardDTO.getOrderId());
                mqDTO.setIccid(cardDTO.getIccid());
                mqDTO.setTenantNo(info.getTenantNo());
                mqList.add(mqDTO);
            } else {
                cardDTO.setRnrStatus(Integer.valueOf(RnrStatus.INIT.getCode()));
            }
            cardDTO.setRnrId(info.getUuid());
            MgRnrCardInfoPO cardInfoPO = MgRnrCardInfoConverter.INSTANCE.dtoToPo(cardDTO);
            cardPOList.add(cardInfoPO);
        }
        this.rnrInfoService.insert(info);
        this.rnrCardInfoService.addRnrCardBatch(cardPOList);
        if (CollectionUtils.isNotEmpty((Collection)bean.getRnrTagList())) {
            this.rnrTagService.addRnrTagFromRnrInfo(info, bean.getRnrTagList());
        }
        if (CollectionUtils.isNotEmpty((Collection)bean.getRnrLiaisonList())) {
            this.rnrLiaisonInfoService.addRnrLiaisonFromRnrInfo(info, bean.getRnrLiaisonList());
        }
        if (bean.getCompanyInfo() != null) {
            this.mgRnrCompanyInfoService.insert(bean.getCompanyInfo());
        }
        this.rnrFileService.addRnrFileFromInfo(info, bean.getRnrFileList());
        this.rnrOrderService.insertOrder(order);
        if (order.getSendWorkOrder().booleanValue()) {
            this.rnrOrderService.sendOrderSystem(order, info, bean.getCardList());
        }
        this.rnrOperationLogService.addRnrOperationLogPOBatch(cardLogList);
        if (!bean.getOrder().getSendWorkOrder().booleanValue() && RnrOrderUtil.needCreateUser((MgRnrInfoDTO)bean.getInfo(), (RnrOrderDTO)bean.getOrder())) {
            this.ciamService.createUser(bean.getInfo());
        }
        if (CollectionUtils.isNotEmpty(mqList)) {
            this.cardNoticeService.sendCardNotice(mqList);
        }
        return Response.createSuccess();
    }

    public Response syncRnrRelation(RnrRelationDTO bean) {
        log.info("Mg syncRnrRelation:" + JSON.toJSONString((Object)bean));
        if (CollectionUtils.isEmpty((Collection)bean.getCardList())) {
            return Response.createError((String)ResponseCode.ICCID_NOT_NULL.getMsg(), (Integer)ResponseCode.ICCID_NOT_NULL.getCode());
        }
        MgRnrInfoDTO info = bean.getInfo();
        RnrOrderDTO order = bean.getOrder();
        ArrayList<MgRnrCardInfoPO> cardPOList = new ArrayList<MgRnrCardInfoPO>();
        for (MgRnrCardInfoDTO cardDTO : bean.getCardList()) {
            cardDTO.setUuid(CuscStringUtils.generateUuid());
            cardDTO.setRnrId(info.getUuid());
            cardDTO.setTenantNo(info.getTenantNo());
            cardDTO.setRoutingKey(info.getRoutingKey());
            cardDTO.setNoticeStatus(Integer.valueOf(NoticeStatusEnum.NONEED.getCode()));
            cardDTO.setOrderId(order.getUuid());
            cardDTO.setRnrStatus(info.getRnrStatus());
            MgRnrCardInfoPO cardInfoPO = MgRnrCardInfoConverter.INSTANCE.dtoToPo(cardDTO);
            cardPOList.add(cardInfoPO);
        }
        this.rnrInfoService.insert(info);
        this.rnrOrderService.insertOrder(order);
        this.rnrCardInfoService.addRnrCardBatch(cardPOList);
        if (CollectionUtils.isNotEmpty((Collection)bean.getRnrTagList())) {
            this.rnrTagService.addRnrTagFromRnrInfo(info, bean.getRnrTagList());
        }
        if (CollectionUtils.isNotEmpty((Collection)bean.getRnrLiaisonList())) {
            this.rnrLiaisonInfoService.addRnrLiaisonFromRnrInfo(info, bean.getRnrLiaisonList());
        }
        if (bean.getCompanyInfo() != null) {
            this.mgRnrCompanyInfoService.insert(bean.getCompanyInfo());
        }
        this.rnrFileService.addRnrFileFromInfo(info, bean.getRnrFileList());
        if (!bean.getOrder().getSendWorkOrder().booleanValue() && RnrOrderUtil.needCreateUser((MgRnrInfoDTO)bean.getInfo(), (RnrOrderDTO)bean.getOrder()) && CuscStringUtils.isEmpty((String)bean.getInfo().getUserId())) {
            this.ciamService.createUser(bean.getInfo());
        }
        return Response.createSuccess((String)"\u540c\u6b65\u5b9e\u540d\u4fe1\u606f\u6210\u529f");
    }

    public void lockRnrIccid(String tenantNo, String iccid, String value) {
        boolean lockStatus = true;
        try {
            lockStatus = this.cacheFactory.getLockService().setNx("CT:RNR:LOCK:" + tenantNo + ":" + iccid, value, RedisConstant.RNR_LOCK_TIME.intValue());
        }
        catch (CacheException e) {
            log.error("RnrRelationServiceImpl.lockRnrIccid \u52a0\u9501\u5931\u8d25\uff0ctenantNo: " + tenantNo + ",iccid: " + iccid + ",value: " + value + ". ", (Throwable)e);
        }
        if (!lockStatus) {
            throw new CuscUserException(RnrResponseCode.WAIT_CHECK.getCode(), RnrResponseCode.WAIT_CHECK.getDescription());
        }
    }

    public void lockRnrIccidList(String tenantNo, List<String> iccidList, String value) {
        for (String iccid : iccidList) {
            this.lockRnrIccid(tenantNo, iccid, value);
        }
    }

    public void unLockRnrIccid(String tenantNo, String iccid) {
        try {
            this.cacheFactory.getLockService().delete(new String[]{"CT:RNR:LOCK:" + tenantNo + ":" + iccid});
        }
        catch (CacheException e) {
            log.error("RnrRelationServiceImpl.unLockRnrIccid \u89e3\u9501\u5931\u8d25\uff0ctenantNo: " + tenantNo + ",iccid: " + iccid + ". ", (Throwable)e);
        }
    }

    public void unLockRnrIccidList(String tenantNo, List<String> iccidList) {
        for (String iccid : iccidList) {
            this.unLockRnrIccid(tenantNo, iccid);
        }
    }

    public void checkIccidStatus(String tenantNo, List<String> iccidList) {
        MgRnrCardInfoDTO checkCardDTO = new MgRnrCardInfoDTO();
        checkCardDTO.setTenantNo(tenantNo);
        checkCardDTO.setIccidList(iccidList);
        boolean ret = this.rnrCardInfoService.checkIccidExists(checkCardDTO);
        if (ret) {
            throw new CuscUserException(RnrResponseCode.WAIT_CHECK.getCode(), RnrResponseCode.WAIT_CHECK.getDescription());
        }
    }

    public Response<RnrRelationDTO> getRnrRelation(MgRnrCardInfoDTO bean) {
        RnrRelationDTO rnrRelationDTO = new RnrRelationDTO();
        MgRnrCardInfoDTO mgRnrCardInfoDTO = new MgRnrCardInfoDTO();
        mgRnrCardInfoDTO.setIccid(bean.getIccid());
        mgRnrCardInfoDTO.setTenantNo(bean.getTenantNo());
        mgRnrCardInfoDTO = this.rnrCardInfoService.getNewRnrCardByIccid(mgRnrCardInfoDTO);
        if (mgRnrCardInfoDTO == null) {
            return Response.createError((String)"\u672a\u67e5\u8be2\u5230\u5df2\u5b9e\u540d\u7684\u5361\u4fe1\u606f");
        }
        rnrRelationDTO.setCardList(Arrays.asList(mgRnrCardInfoDTO));
        MgRnrInfoDTO mgRnrInfoDTO = new MgRnrInfoDTO();
        mgRnrInfoDTO.setUuid(mgRnrCardInfoDTO.getRnrId());
        MgRnrInfoDTO byUuid = this.rnrInfoService.getByUuid(mgRnrInfoDTO);
        rnrRelationDTO.setInfo(byUuid);
        if (byUuid != null && byUuid.getIsCompany() != 0 && CuscStringUtils.isNotEmpty((String)byUuid.getRnrCompanyId())) {
            MgRnrCompanyInfoDTO rnrCompanyInfoDTO = new MgRnrCompanyInfoDTO();
            rnrCompanyInfoDTO.setUuid(byUuid.getRnrCompanyId());
            MgRnrCompanyInfoDTO mgRnrCompanyInfoDTO = this.rnrCompanyInfoService.getByUuid(rnrCompanyInfoDTO);
            rnrRelationDTO.setCompanyInfo(mgRnrCompanyInfoDTO);
        }
        MgRnrLiaisonInfoDTO rnrLiaisonInfoDTO = new MgRnrLiaisonInfoDTO();
        rnrLiaisonInfoDTO.setRnrId(mgRnrCardInfoDTO.getRnrId());
        rnrLiaisonInfoDTO.setTenantNo(mgRnrCardInfoDTO.getTenantNo());
        List liaisonInfoList = this.rnrLiaisonInfoService.queryByList(rnrLiaisonInfoDTO);
        rnrRelationDTO.setRnrLiaisonList(liaisonInfoList);
        MgRnrFileDTO fileDTO = new MgRnrFileDTO();
        fileDTO.setRnrId(mgRnrCardInfoDTO.getRnrId());
        fileDTO.setTenantNo(bean.getTenantNo());
        rnrRelationDTO.setRnrFileList(this.rnrFileService.getByRnrid(fileDTO));
        return Response.createSuccess((Object)rnrRelationDTO);
    }

    private Response checkDTOValid(RnrRelationDTO bean) {
        Set constraintViolations = SpringValidationUtil.groupVerificationParameters((Object)bean, (Class[])new Class[]{SaveRelation.class});
        if (!constraintViolations.isEmpty()) {
            String message = ((ConstraintViolation)constraintViolations.stream().findFirst().get()).getMessage();
            return Response.createError((String)message, (Integer)ResponseCode.INVALID_DATA.getCode());
        }
        return Response.createSuccess();
    }
}

