/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.rnr.common.dto.RnrMqMessageDTO;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOptLogSubTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderType;
import com.cusc.nirvana.user.rnr.mg.converter.RnrOrderConverter;
import com.cusc.nirvana.user.rnr.mg.dao.RnrOrderDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.RnrOrderOperationLogPO;
import com.cusc.nirvana.user.rnr.mg.dao.entity.RnrOrderPO;
import com.cusc.nirvana.user.rnr.mg.dto.LocalVerifyListDTO;
import com.cusc.nirvana.user.rnr.mg.dto.LocalVerifyListRqDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.service.IOrderNoticeService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderOperationLogService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import com.cusc.nirvana.user.rnr.mg.util.crypt.DesensitizationUtil;
import com.cusc.nirvana.user.rnr.workorder.constants.WorkOrderTypeEnum;
import com.cusc.nirvana.user.rnr.workorder.context.WorkOrderContext;
import com.cusc.nirvana.user.rnr.workorder.dto.WorkOrderStarRequestDTO;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RnrOrderServiceImpl
extends ServiceImpl<RnrOrderDao, RnrOrderPO>
implements IRnrOrderService {
    private static final Logger log = LoggerFactory.getLogger(RnrOrderServiceImpl.class);
    @Autowired
    private IRnrOrderOperationLogService rnrOrderOperationLogService;
    @Autowired
    private IOrderNoticeService orderNoticeService;
    @Autowired
    private WorkOrderContext workOrderContext;
    @Autowired
    private RnrOrderDao rnrOrderDao;
    @Value(value="${mg.workOrder.applicationId:112f1c67de134e669379e24f160fb25a}")
    private String applicationId;
    @Value(value="${mg.workOrder.sendOrderSystemFlag:0}")
    private String sendOrderSystemFlag;

    public RnrOrderDTO getByUuid(RnrOrderDTO bean) {
        RnrOrderPO record = this.getPoByUuid(bean.getUuid());
        return RnrOrderConverter.INSTANCE.poToDto(record);
    }

    public List<RnrOrderDTO> queryByList(RnrOrderDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getRnrId()), (Object)"rnr_id", (Object)bean.getRnrId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getOrderSource()), (Object)"order_source", (Object)bean.getOrderSource());
        queryWrapper.eq(bean.getRnrBizzType() != null, (Object)"rnr_bizz_type", (Object)bean.getRnrBizzType());
        queryWrapper.eq(bean.getOrderType() != null, (Object)"order_type", (Object)bean.getOrderType());
        queryWrapper.eq(bean.getOrderStatus() != null, (Object)"order_status", (Object)bean.getOrderStatus());
        List record = this.list((Wrapper)queryWrapper);
        return RnrOrderConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<RnrOrderDTO> queryByPage(RnrOrderDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq(bean.getOrderStatus() != null, (Object)"order_status", (Object)bean.getOrderStatus());
        queryWrapper.le(bean.getCreateTime() != null, (Object)"create_time", (Object)bean.getCreateTime());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, RnrOrderDTO.class);
    }

    @Transactional
    public RnrOrderDTO insert(RnrOrderDTO bean) {
        RnrOrderPO rnrOrderPO = RnrOrderConverter.INSTANCE.dtoToPo(bean);
        if (CuscStringUtils.isEmpty((String)bean.getUuid())) {
            rnrOrderPO.setUuid(CuscStringUtils.generateUuid());
            bean.setUuid(rnrOrderPO.getUuid());
        }
        this.save((Object)rnrOrderPO);
        return bean;
    }

    @Transactional
    public RnrOrderDTO update(RnrOrderDTO bean) {
        RnrOrderPO MgRnrOrderPO = this.getPoByUuid(bean.getUuid());
        if (MgRnrOrderPO == null) {
            return null;
        }
        RnrOrderPO tmpBean = RnrOrderConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(MgRnrOrderPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(RnrOrderDTO bean) {
        RnrOrderPO MgRnrOrderPO = this.getPoByUuid(bean.getUuid());
        if (MgRnrOrderPO == null) {
            return false;
        }
        RnrOrderPO tmpBean = new RnrOrderPO();
        tmpBean.setId(MgRnrOrderPO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    public void sendBatchOrderMQ(List<RnrOrderDTO> orderList, Integer orderDelay) {
        RnrMqMessageDTO mqMsg = orderDelay != null && orderDelay > 0 ? RnrMqMessageDTO.createDelayMsg((int)orderDelay, orderList) : RnrMqMessageDTO.createMsg(orderList);
        this.orderNoticeService.sendOrderMsg(mqMsg);
    }

    public void insertOrder(RnrOrderDTO order) {
        Date now = new Date();
        RnrOrderPO orderPO = RnrOrderConverter.INSTANCE.dtoToPo(order);
        if (Boolean.TRUE.equals(order.getSendWorkOrder())) {
            orderPO.setOrderStatus(RnrOrderStatusEnum.ASSIGNMENT.getCode());
        } else {
            orderPO.setAuditTime(now);
            orderPO.setAllocateTime(now);
        }
        RnrOrderOperationLogPO orderOperationLogPO = new RnrOrderOperationLogPO();
        orderOperationLogPO.setUuid(CuscStringUtils.generateUuid());
        orderOperationLogPO.setOrderId(orderPO.getUuid());
        orderOperationLogPO.setCreator(orderPO.getCreator() == null ? "0" : orderPO.getCreator());
        orderOperationLogPO.setOptType(RnrOptLogSubTypeEnum.CREATE_OPERATE.getCode());
        orderOperationLogPO.setUpdatedCode(Long.valueOf(0L));
        orderOperationLogPO.setUpdatedContent("\u672c\u5355\u7531\u5de5\u53f7:" + orderPO.getCreator() + "\u521b\u5efa");
        orderOperationLogPO.setOptTime(now);
        orderOperationLogPO.setTenantNo(orderPO.getTenantNo());
        orderOperationLogPO.setRnrId(orderPO.getRnrId());
        ((RnrOrderDao)this.baseMapper).insert((Object)orderPO);
        this.rnrOrderOperationLogService.insertBatchOrderOperationLog(Collections.singletonList(orderOperationLogPO));
    }

    public Integer insertBatchOrder(List<RnrOrderDTO> orderList) {
        Date now = new Date();
        ArrayList<RnrOrderPO> orderSaveList = new ArrayList<RnrOrderPO>();
        ArrayList<RnrOrderOperationLogPO> orderLogList = new ArrayList<RnrOrderOperationLogPO>();
        for (RnrOrderDTO order : orderList) {
            RnrOrderPO orderPO = RnrOrderConverter.INSTANCE.dtoToPo(order);
            if (orderPO.getOrderStatus() == RnrOrderStatusEnum.PASS.getCode()) {
                orderPO.setAuditTime(now);
                orderPO.setAllocateTime(now);
            }
            orderSaveList.add(orderPO);
            RnrOrderOperationLogPO orderOperationLogPO = new RnrOrderOperationLogPO();
            orderOperationLogPO.setUuid(CuscStringUtils.generateUuid());
            orderOperationLogPO.setCreator(orderPO.getCreator() == null ? "0" : orderPO.getCreator());
            orderOperationLogPO.setOptType(RnrOptLogSubTypeEnum.CREATE_OPERATE.getCode());
            orderOperationLogPO.setUpdatedCode(Long.valueOf(0L));
            orderOperationLogPO.setUpdatedContent("\u672c\u5355\u7531\u5de5\u53f7:" + orderPO.getCreator() + "\u521b\u5efa");
            orderOperationLogPO.setOptTime(now);
            orderOperationLogPO.setOrderId(orderPO.getUuid());
            orderOperationLogPO.setTenantNo(orderPO.getTenantNo());
            orderOperationLogPO.setRnrId(orderPO.getRnrId());
            orderLogList.add(orderOperationLogPO);
        }
        ((RnrOrderDao)this.baseMapper).insertBatchOrder(orderSaveList);
        this.rnrOrderOperationLogService.insertBatchOrderOperationLog(orderLogList);
        return orderSaveList.size();
    }

    public void sendThirdBatchOrder(List<RnrOrderDTO> orderList) {
    }

    public void sendOrderSystem(RnrOrderDTO rnrOrderDTO, MgRnrInfoDTO mgRnrInfoDTO, List<MgRnrCardInfoDTO> list) {
        WorkOrderStarRequestDTO orderStarRequestDTO;
        if ("0".equals(this.sendOrderSystemFlag)) {
            log.info("work order begin local verify mode, dont send rnrOrderSystem");
            return;
        }
        String name = DesensitizationUtil.desensitizeName((String)mgRnrInfoDTO.getFullName());
        String phone = DesensitizationUtil.desensitizePhone((String)mgRnrInfoDTO.getPhone());
        if (CollectionUtils.isEmpty(list)) {
            orderStarRequestDTO = this.orderDtoToWorkOrderDTO(rnrOrderDTO, new String[]{name, phone, "", ""});
        } else {
            MgRnrCardInfoDTO mgRnrCardInfoDTO = list.get(0);
            boolean notSingle = list.size() > 1;
            String vin = notSingle ? mgRnrCardInfoDTO.getIotId() + ",..." : mgRnrCardInfoDTO.getIotId();
            String iccid = notSingle ? mgRnrCardInfoDTO.getIccid() + ",..." : mgRnrCardInfoDTO.getIccid();
            orderStarRequestDTO = this.orderDtoToWorkOrderDTO(rnrOrderDTO, new String[]{name, phone, vin, iccid});
        }
        log.info("\u53d1\u9001\u5de5\u5355\uff1a{}", (Object)JSON.toJSONString((Object)orderStarRequestDTO));
        String workOrderCode = this.workOrderContext.getHandler().startOrder(orderStarRequestDTO);
        if (StringUtils.isBlank((CharSequence)workOrderCode)) {
            log.error("\u53d1\u9001\u5de5\u5355\u7cfb\u7edf\u5931\u8d25,\u8ba2\u5355UUID:" + rnrOrderDTO.getUuid());
            throw new CuscUserException("", "\u53d1\u9001\u5de5\u5355\u7cfb\u7edf\u5931\u8d25");
        }
        ((RnrOrderDao)this.baseMapper).updateOrderApproveNo(rnrOrderDTO.getUuid(), workOrderCode);
    }

    @Transactional
    public void updateOrderStatus(List<String> orderIds, int status) {
        ((RnrOrderDao)this.baseMapper).updateOrderStatus(orderIds, status);
    }

    private WorkOrderStarRequestDTO orderDtoToWorkOrderDTO(RnrOrderDTO rnrOrderDTO, String ... args) {
        WorkOrderStarRequestDTO requestDTO = new WorkOrderStarRequestDTO();
        requestDTO.setBusinessObjectId(rnrOrderDTO.getUuid());
        requestDTO.setTenantUuid(rnrOrderDTO.getTenantNo());
        RnrOrderType typeByCode = RnrOrderType.getTypeByCode((int)rnrOrderDTO.getOrderType());
        if (typeByCode == null) {
            throw new CuscUserException("", "\u5de5\u5355\u7c7b\u578b\u9519\u8bef");
        }
        WorkOrderTypeEnum workOrderTypeEnum = WorkOrderTypeEnum.getWorkOrderTypeEnumByRnrOrderType((RnrOrderType)typeByCode);
        requestDTO.setWorkOrderKey(workOrderTypeEnum.getKey());
        requestDTO.setName(workOrderTypeEnum.getWorkOrderName((Object[])args));
        requestDTO.setStartUserId(rnrOrderDTO.getCreator());
        requestDTO.setApplicationUuid(this.applicationId);
        return requestDTO;
    }

    public RnrOrderPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (RnrOrderPO)this.getOne((Wrapper)queryWrapper);
    }

    public Integer orderTotal(LocalVerifyListRqDTO rq) {
        return this.rnrOrderDao.orderTotal(rq);
    }

    public List<LocalVerifyListDTO> orderList(LocalVerifyListRqDTO rq) {
        return this.rnrOrderDao.orderList(rq, Integer.valueOf((rq.getCurrPage() - 1) * rq.getPageSize()), rq.getPageSize());
    }

    public String getOrganNameForOrgId(String orgId) {
        return this.rnrOrderDao.getOrganNameForOrgId(orgId);
    }

    public String getOrganNameForOrganCode(String organCode) {
        return this.rnrOrderDao.getOrganNameForOrganCode(organCode);
    }
}

