/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.core.codec.Base64Encoder;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.rnr.common.constants.ResponseCode;
import com.cusc.nirvana.user.rnr.mg.service.IFileService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OssFileServiceImpl
implements IFileService {
    private static final Logger log = LoggerFactory.getLogger(OssFileServiceImpl.class);
    @Value(value="${oss.endpoint}")
    private String endpoint;
    @Value(value="${oss.accessKeyId}")
    private String accessKeyId;
    @Value(value="${oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${oss.bucketName}")
    private String bucketName;

    public String upLoadImage(InputStream inputStream, String suffix) {
        return this.upLoadFile(inputStream, suffix);
    }

    public String upLoadFile(InputStream inputStream, String suffix) {
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        String ossFileKey = CuscStringUtils.generateUuid() + "." + suffix;
        PutObjectRequest request = new PutObjectRequest(this.bucketName, ossFileKey, inputStream);
        ossClient.putObject(request);
        ossClient.shutdown();
        return ossFileKey;
    }

    public String upLoadFileBase64Img(String base64, String suffix) {
        try {
            byte[] bytes = Base64Decoder.decode((CharSequence)base64);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            return this.upLoadFile((InputStream)inputStream, suffix);
        }
        catch (Exception e) {
            log.error("upLoadFileBase64Img has error");
            return "";
        }
    }

    public String getFileUrl(String fileKey) {
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        Date date = new Date(System.currentTimeMillis() + 3600000L);
        URL url = ossClient.generatePresignedUrl(this.bucketName, fileKey, date);
        log.info("OssFileServiceImpl getFileUrl fileKey = {},url = {}", (Object)fileKey, (Object)url.toString());
        return url.toString();
    }

    public String downLoadBase64(String fileKey) {
        try {
            OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            GetObjectRequest request = new GetObjectRequest(this.bucketName, fileKey);
            OSSObject object = ossClient.getObject(request);
            InputStream inputStream = object.getObjectContent();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            return Base64Encoder.encode((byte[])bytes);
        }
        catch (Exception e) {
            throw new CuscUserException(ResponseCode.SYSTEM_ERROR.getCode(), "\u6587\u4ef6oss\u4e0b\u8f7d\u5931\u8d25");
        }
    }

    public Double getFileSize(String fileKey) {
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        boolean existFlag = ossClient.doesObjectExist(this.bucketName, fileKey);
        if (!existFlag) {
            throw new CuscUserException("500", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        ObjectMetadata objectMetadata = ossClient.getObjectMetadata(this.bucketName, fileKey);
        Double fileSize = (double)objectMetadata.getContentLength() / 1024.0;
        ossClient.shutdown();
        return fileSize;
    }

    public byte[] downLoadBytes(String fileKey) {
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        GetObjectRequest request = new GetObjectRequest(this.bucketName, fileKey);
        OSSObject object = ossClient.getObject(request);
        InputStream inputStream = object.getObjectContent();
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            return bytes;
        }
        catch (Exception e) {
            throw new CuscUserException(ResponseCode.SYSTEM_ERROR.getCode(), "\u6587\u4ef6oss bytes\u4e0b\u8f7d\u5931\u8d25");
        }
    }
}

