/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.converter.OrgSimRelConverter;
import com.cusc.nirvana.user.rnr.mg.dao.OrgSimRelDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.OrgSimRelPO;
import com.cusc.nirvana.user.rnr.mg.dto.OrgSimRelDTO;
import com.cusc.nirvana.user.rnr.mg.dto.OrgSimRelQueryDTO;
import com.cusc.nirvana.user.rnr.mg.service.IOrgSimRelService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.DateUtils;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrgSimRelServiceImpl
extends ServiceImpl<OrgSimRelDao, OrgSimRelPO>
implements IOrgSimRelService {
    public OrgSimRelDTO getByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        OrgSimRelPO simRelPO = (OrgSimRelPO)this.getOne((Wrapper)queryWrapper);
        return simRelPO == null ? null : OrgSimRelConverter.INSTANCE.poToDto(simRelPO);
    }

    public OrgSimRelDTO getByIccid(String iccid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"iccid", (Object)iccid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        OrgSimRelPO simRelPO = (OrgSimRelPO)this.getOne((Wrapper)queryWrapper);
        return simRelPO == null ? null : OrgSimRelConverter.INSTANCE.poToDto(simRelPO);
    }

    public PageResult<OrgSimRelDTO> queryByPage(OrgSimRelQueryDTO queryDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"org_uuid", (Object)queryDTO.getOrgUuid());
        if (CuscStringUtils.isNotEmpty((String)queryDTO.getTagUuid())) {
            queryWrapper.eq((Object)"tag_code", (Object)queryDTO.getTagUuid());
        }
        if (CuscStringUtils.isNotEmpty((String)queryDTO.getIccid())) {
            queryWrapper.eq((Object)"iccid", (Object)queryDTO.getIccid());
        }
        if (CuscStringUtils.isNotEmpty((String)queryDTO.getVin())) {
            queryWrapper.eq((Object)"vin", (Object)queryDTO.getVin());
        }
        if (null != queryDTO.getBindStatus()) {
            queryWrapper.eq((Object)"bind_status", (Object)queryDTO.getBindStatus());
        }
        if (queryDTO.getStartCreateTime() != null) {
            queryWrapper.ge((Object)"create_time", (Object)DateUtils.formatDate((LocalDateTime)DateUtils.convertDateToLDT((Date)queryDTO.getStartCreateTime()), (String)"yyyy-MM-dd"));
        }
        if (queryDTO.getEndCreateTime() != null) {
            queryWrapper.le((Object)"create_time", (Object)(DateUtils.formatDate((LocalDateTime)DateUtils.convertDateToLDT((Date)queryDTO.getEndCreateTime()), (String)"yyyy-MM-dd") + " 23:59:59"));
        }
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        Page poPage = (Page)this.page((IPage)new Page((long)queryDTO.getCurrPage().intValue(), (long)queryDTO.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)poPage, OrgSimRelDTO.class);
    }

    public List<OrgSimRelDTO> queryByList(List<String> iccids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"iccid", iccids);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    public List<OrgSimRelDTO> queryByVin(String vin) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"vin", (Object)vin);
        queryWrapper.eq((Object)"bind_status", (Object)"0");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    public OrgSimRelDTO insert(OrgSimRelDTO simRelDTO) {
        OrgSimRelDTO tmpDto = this.getByIccid(simRelDTO.getIccid());
        if (tmpDto != null) {
            return tmpDto;
        }
        simRelDTO.setUuid(CuscStringUtils.generateUuid());
        OrgSimRelPO orgSimRelPO = OrgSimRelConverter.INSTANCE.dtoToPo(simRelDTO);
        this.save((Object)orgSimRelPO);
        return simRelDTO;
    }

    public Integer insertBatch(List<OrgSimRelDTO> simRelDTOS) {
        simRelDTOS.forEach(dto -> {
            OrgSimRelDTO tmpDto = this.getByIccid(dto.getIccid());
            if (tmpDto == null) {
                dto.setUuid(CuscStringUtils.generateUuid());
            } else {
                dto.setUuid(tmpDto.getUuid());
                dto.setId(tmpDto.getId());
            }
        });
        boolean flag = true;
        if (!CollectionUtils.isEmpty(simRelDTOS)) {
            flag = this.saveOrUpdateBatch((Collection)OrgSimRelConverter.INSTANCE.dtoListToPoList(simRelDTOS));
        }
        return flag ? simRelDTOS.size() : 0;
    }

    public OrgSimRelDTO update(OrgSimRelDTO simRelDTO) {
        OrgSimRelDTO bean = this.getByUuid(simRelDTO.getUuid());
        if (bean == null) {
            return null;
        }
        simRelDTO.setId(bean.getId());
        OrgSimRelPO orgSimRelPO = OrgSimRelConverter.INSTANCE.dtoToPo(simRelDTO);
        this.updateById((Object)orgSimRelPO);
        return simRelDTO;
    }

    public boolean updateBindStatus(String iccid, String vin, Integer bindStatus) {
        OrgSimRelPO updatePo = new OrgSimRelPO();
        updatePo.setBindStatus(bindStatus);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"iccid", (Object)iccid);
        wrapper.eq((Object)"vin", (Object)vin);
        wrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return this.update((Object)updatePo, (Wrapper)wrapper);
    }

    public boolean deleteById(OrgSimRelDTO simRelDTO) {
        OrgSimRelDTO dto = this.getByUuid(simRelDTO.getUuid());
        if (dto == null || !dto.getOrgUuid().equals(simRelDTO.getOrgUuid())) {
            return false;
        }
        simRelDTO.setIsDelete(Integer.valueOf(1));
        return this.updateById((Object)OrgSimRelConverter.INSTANCE.dtoToPo(simRelDTO));
    }
}

