/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.converter.OrgBusinessTagConverter;
import com.cusc.nirvana.user.rnr.mg.dao.OrgBusinessTagDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.OrgBusinessTagPO;
import com.cusc.nirvana.user.rnr.mg.dto.OrgBusinessTagDTO;
import com.cusc.nirvana.user.rnr.mg.service.IOrgBusinessTagService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OrgBusinessTagServiceImpl
extends ServiceImpl<OrgBusinessTagDao, OrgBusinessTagPO>
implements IOrgBusinessTagService {
    public Response<OrgBusinessTagDTO> getByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        OrgBusinessTagPO po = (OrgBusinessTagPO)this.getOne((Wrapper)queryWrapper);
        return Response.createSuccess((Object)OrgBusinessTagConverter.INSTANCE.poToDto(po));
    }

    public Response<OrgBusinessTagDTO> getByTagCode(String tenantNo, String tagCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_no", (Object)tenantNo);
        queryWrapper.eq((Object)"tag_code", (Object)tagCode);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        OrgBusinessTagPO po = (OrgBusinessTagPO)this.getOne((Wrapper)queryWrapper);
        return Response.createSuccess((Object)OrgBusinessTagConverter.INSTANCE.poToDto(po));
    }

    public Response<OrgBusinessTagDTO> insert(OrgBusinessTagDTO tagDTO) {
        if (this.getByTagCode(tagDTO.getTenantNo(), tagDTO.getTagCode()) != null) {
            return Response.createSuccess((String)"\u6807\u7b7e\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        tagDTO.setUuid(CuscStringUtils.generateUuid());
        if (this.save((Object)OrgBusinessTagConverter.INSTANCE.dtoToPo(tagDTO))) {
            return Response.createSuccess((Object)tagDTO);
        }
        return Response.createError((String)"\u65b0\u589e\u6807\u7b7e\u5931\u8d25!");
    }

    public Response<OrgBusinessTagDTO> update(OrgBusinessTagDTO tagDTO) {
        OrgBusinessTagDTO tmpDto = (OrgBusinessTagDTO)this.getByTagCode(tagDTO.getTenantNo(), tagDTO.getTagCode()).getData();
        if (tmpDto != null && !tmpDto.getUuid().equals(tagDTO.getUuid())) {
            return Response.createSuccess((String)"\u6807\u7b7e\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"uuid", (Object)tagDTO.getUuid());
        wrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        boolean flag = this.update((Object)OrgBusinessTagConverter.INSTANCE.dtoToPo(tagDTO), (Wrapper)wrapper);
        return Response.createSuccess((Object)flag);
    }

    public Response<Integer> remove(String uuid) {
        OrgBusinessTagDTO tagDTO = (OrgBusinessTagDTO)this.getByUuid(uuid).getData();
        if (tagDTO == null) {
            return Response.createSuccess((Object)0);
        }
        tagDTO.setIsDelete(Integer.valueOf(1));
        tagDTO = (OrgBusinessTagDTO)this.update(tagDTO).getData();
        return Response.createSuccess((Object)tagDTO);
    }

    public Response<List<OrgBusinessTagDTO>> query(String tenantNo, String orgUuid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_no", (Object)tenantNo);
        if (CuscStringUtils.isNotEmpty((String)orgUuid)) {
            wrapper.eq((Object)"org_uuid", (Object)orgUuid);
        }
        wrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        List pos = this.list((Wrapper)wrapper);
        return Response.createSuccess((Object)OrgBusinessTagConverter.INSTANCE.poListToDtoList(pos));
    }
}

