/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.converter.OpenTenantRelationConverter;
import com.cusc.nirvana.user.rnr.mg.dao.OpenTenantRelationDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.OpenTenantRelationPO;
import com.cusc.nirvana.user.rnr.mg.dto.OpenTenantRelationDTO;
import com.cusc.nirvana.user.rnr.mg.service.IOpenTenantRelationService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpenTenantRelationServiceImpl
extends ServiceImpl<OpenTenantRelationDao, OpenTenantRelationPO>
implements IOpenTenantRelationService {
    public OpenTenantRelationDTO getByUuid(OpenTenantRelationDTO bean) {
        OpenTenantRelationPO record = this.getPoByUuid(bean.getUuid());
        return OpenTenantRelationConverter.INSTANCE.poToDto(record);
    }

    public List<OpenTenantRelationDTO> queryByList(OpenTenantRelationDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getOpenTenantId()), (Object)"open_tenant_id", (Object)bean.getOpenTenantId());
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        List record = this.list((Wrapper)queryWrapper);
        return OpenTenantRelationConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<OpenTenantRelationDTO> queryByPage(OpenTenantRelationDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getOpenTenantId()), (Object)"open_tenant_id", (Object)bean.getOpenTenantId());
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, OpenTenantRelationDTO.class);
    }

    @Transactional
    public OpenTenantRelationDTO insert(OpenTenantRelationDTO bean) {
        OpenTenantRelationPO openTenantRelationPO = OpenTenantRelationConverter.INSTANCE.dtoToPo(bean);
        openTenantRelationPO.setUuid(CuscStringUtils.generateUuid());
        this.save((Object)openTenantRelationPO);
        bean.setUuid(openTenantRelationPO.getUuid());
        return bean;
    }

    @Transactional
    public OpenTenantRelationDTO update(OpenTenantRelationDTO bean) {
        OpenTenantRelationPO openTenantRelationPO = this.getPoByUuid(bean.getUuid());
        if (openTenantRelationPO == null) {
            return null;
        }
        OpenTenantRelationPO tmpBean = OpenTenantRelationConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(openTenantRelationPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(OpenTenantRelationDTO bean) {
        OpenTenantRelationPO openTenantRelationPO = this.getPoByUuid(bean.getUuid());
        if (openTenantRelationPO == null) {
            return false;
        }
        OpenTenantRelationPO tmpBean = new OpenTenantRelationPO();
        tmpBean.setId(openTenantRelationPO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    private OpenTenantRelationPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (OpenTenantRelationPO)this.getOne((Wrapper)queryWrapper);
    }
}

