/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.common.cloud.CloudMethod;
import com.cusc.nirvana.user.rnr.common.cloud.CloudService;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.UploadResultDto;
import com.cusc.nirvana.user.rnr.mg.dto.VinCardDTO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NotifyCloudService {
    private static final Logger log = LoggerFactory.getLogger(NotifyCloudService.class);
    @Autowired
    private CloudService cloudService;

    @Async
    public Response notifyResult(List<MgRnrCardInfoDTO> dtoList, String rnrBizzType, String serialNumber, String orgId, String resultCode) {
        Response response = null;
        try {
            ArrayList vinCardList = new ArrayList();
            dtoList.forEach(mgRnrCardInfoDTO -> {
                VinCardDTO cardDto = new VinCardDTO();
                cardDto.setIccid(mgRnrCardInfoDTO.getIccid());
                cardDto.setVin(mgRnrCardInfoDTO.getIotId());
                cardDto.setOldIccid(mgRnrCardInfoDTO.getOldCardId());
                cardDto.setResultCode(resultCode);
                vinCardList.add(cardDto);
            });
            UploadResultDto resultDto = new UploadResultDto();
            resultDto.setSerialNumber(serialNumber);
            resultDto.setRnrBizzType(rnrBizzType);
            resultDto.setVinCardList(vinCardList);
            resultDto.setOrgId(orgId);
            log.info("\u901a\u77e5\u4e91\u7aef,\u5b9e\u540d\u8bf7\u6c42\u662f = {}", (Object)resultDto);
            response = this.cloudService.postForResponse(CloudMethod.NOTIFY_RESULT, (Object)resultDto, String.class);
            log.info("\u901a\u77e5\u4e91\u7aef,\u8fd4\u56de\u7ed3\u679c\u662f = {}", (Object)response);
            if (!response.isSuccess().booleanValue()) {
                log.error("\u901a\u77e5\u4e91\u7aef\u5931\u8d25,serialNumber = {}", (Object)serialNumber);
            }
        }
        catch (Exception e) {
            log.error("\u5b9e\u540d\u7ed3\u679c\u901a\u77e5\u4e91\u7aef\u51fa\u73b0\u5f02\u5e38 = {}", (Object)e.getMessage());
        }
        return response;
    }
}

