/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.constants.CryptKeyHelper;
import com.cusc.nirvana.user.rnr.mg.converter.MgVehicleCompanyConverter;
import com.cusc.nirvana.user.rnr.mg.dao.MgVehicleCompanyDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgVehicleCompanyPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCompanyInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgVehicleCompanyDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCompanyInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrFileService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgVehicleCompanyService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MgVehicleCompanyServiceImpl
extends ServiceImpl<MgVehicleCompanyDao, MgVehicleCompanyPO>
implements IMgVehicleCompanyService {
    @Autowired
    IMgRnrCompanyInfoService companyInfoService;
    @Autowired
    IMgRnrInfoService rnrInfoService;
    @Autowired
    IMgRnrFileService fileService;

    public MgVehicleCompanyDTO getByUuid(MgVehicleCompanyDTO bean) {
        MgVehicleCompanyPO record = this.getPoByUuid(bean.getUuid());
        return MgVehicleCompanyConverter.INSTANCE.poToDto(record);
    }

    public MgVehicleCompanyDTO getVehicleCompany(MgVehicleCompanyDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getOrgId()), (Object)"org_id", (Object)CuscStringUtils.isNotEmpty((String)bean.getOrgId()));
        MgVehicleCompanyPO vehicleCompany = (MgVehicleCompanyPO)this.getOne((Wrapper)queryWrapper);
        return MgVehicleCompanyConverter.INSTANCE.poToDto(vehicleCompany);
    }

    public List<MgVehicleCompanyDTO> queryByList(MgVehicleCompanyDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getTenantNo()), (Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getCompanyName()), (Object)"company_name", (Object)CryptKeyHelper.encrypt((String)bean.getCompanyName()));
        List record = this.list((Wrapper)queryWrapper);
        return MgVehicleCompanyConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<MgVehicleCompanyDTO> queryByPage(MgVehicleCompanyDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, MgVehicleCompanyDTO.class);
    }

    @Transactional
    public MgVehicleCompanyDTO insert(MgVehicleCompanyDTO bean) {
        MgVehicleCompanyPO vehicleCompanyPO = MgVehicleCompanyConverter.INSTANCE.dtoToPo(bean);
        vehicleCompanyPO.setUuid(CuscStringUtils.generateUuid());
        this.save((Object)vehicleCompanyPO);
        bean.setUuid(vehicleCompanyPO.getUuid());
        return bean;
    }

    @Transactional
    public MgVehicleCompanyDTO update(MgVehicleCompanyDTO bean) {
        MgVehicleCompanyPO MgVehicleCompanyPO2 = this.getPoByUuid(bean.getUuid());
        if (MgVehicleCompanyPO2 == null) {
            return null;
        }
        MgVehicleCompanyPO tmpBean = MgVehicleCompanyConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(MgVehicleCompanyPO2.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(MgVehicleCompanyDTO bean) {
        MgVehicleCompanyPO MgVehicleCompanyPO2 = this.getPoByUuid(bean.getUuid());
        if (MgVehicleCompanyPO2 == null) {
            return false;
        }
        MgVehicleCompanyPO tmpBean = new MgVehicleCompanyPO();
        tmpBean.setId(MgVehicleCompanyPO2.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    @Transactional
    public MgVehicleCompanyDTO saveByRnrId(MgVehicleCompanyDTO bean) {
        MgRnrCompanyInfoDTO company = new MgRnrCompanyInfoDTO();
        company.setRnrId(bean.getFirstRnrId());
        company = this.companyInfoService.getByRnrid(company);
        if (company == null) {
            return null;
        }
        bean.setCompanyName(company.getCompanyName());
        bean.setCompanyCertType(company.getCompanyCertType());
        bean.setCompanyCertNumber(company.getCompanyCertNumber());
        this.insert(bean);
        return bean;
    }

    private MgVehicleCompanyPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgVehicleCompanyPO)this.getOne((Wrapper)queryWrapper);
    }
}

