/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.alibaba.fastjson.JSON;
import com.cache.redis.util.FastJsonUtils;
import com.cusc.nirvana.common.loader.CollectionUtils;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.rnr.common.constants.ResponseCode;
import com.cusc.nirvana.user.rnr.mg.constants.MessageCallbackStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.NoticeStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrBizzTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOptLogBizTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOptLogOptTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOptLogSubTypeEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrOrderStatusEnum;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrCardInfoConverter;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrCardInfoPO;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrOperationLogPO;
import com.cusc.nirvana.user.rnr.mg.dto.InfoLogCommentDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgCardNoticeDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCardInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrOrderDTO;
import com.cusc.nirvana.user.rnr.mg.dto.RnrRelationDTO;
import com.cusc.nirvana.user.rnr.mg.dto.SurplusConfirmDto;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardInfoService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCardNoticeService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrOperationLogService;
import com.cusc.nirvana.user.rnr.mg.service.IMgSurplusBindService;
import com.cusc.nirvana.user.rnr.mg.service.IMqSendService;
import com.cusc.nirvana.user.rnr.mg.service.IProjectService;
import com.cusc.nirvana.user.rnr.mg.service.IRnrOrderService;
import com.cusc.nirvana.user.rnr.mg.service.impl.NotifyCloudService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MgSurplusBindServiceImpl
implements IMgSurplusBindService {
    private static final Logger log = LoggerFactory.getLogger(MgSurplusBindServiceImpl.class);
    @Autowired
    private IRnrOrderService rnrOrderService;
    @Autowired
    private IMgRnrCardInfoService rnrCardInfoService;
    @Autowired
    private IMgRnrOperationLogService rnrOperationLogService;
    @Autowired
    private IMgRnrCardNoticeService cardNoticeService;
    @Autowired
    private IProjectService projectService;
    @Autowired
    private IMqSendService mqSendService;
    @Autowired
    private NotifyCloudService notifyCloudService;

    @Transactional(rollbackFor={Throwable.class})
    public String saveRelation(RnrRelationDTO relationDTO) {
        log.info("Mg realtionInfo:" + JSON.toJSONString((Object)relationDTO));
        if (CollectionUtils.isEmpty((Collection)relationDTO.getCardList())) {
            throw new CuscUserException(ResponseCode.ICCID_NOT_NULL.getCode(), ResponseCode.ICCID_NOT_NULL.getMsg());
        }
        MgRnrInfoDTO info = relationDTO.getInfo();
        RnrOrderDTO order = relationDTO.getOrder();
        order.setRnrId(info.getUuid());
        InfoLogCommentDTO comment = new InfoLogCommentDTO();
        comment.setUserId(info.getUuid());
        comment.setLang(LocaleContextHolder.getLocale().toString());
        String logComment = FastJsonUtils.convertObjectToJSON((Object)comment);
        ArrayList<MgRnrOperationLogPO> cardLogList = new ArrayList<MgRnrOperationLogPO>();
        ArrayList<MgRnrCardInfoPO> cardPOList = new ArrayList<MgRnrCardInfoPO>();
        for (MgRnrCardInfoDTO cardDTO : relationDTO.getCardList()) {
            cardDTO.setUuid(CuscStringUtils.generateUuid());
            cardDTO.setRnrId(info.getUuid());
            cardDTO.setTenantNo(info.getTenantNo());
            cardDTO.setRoutingKey(info.getRoutingKey());
            cardDTO.setOrderId(order.getUuid());
            MgRnrCardInfoPO cardInfoPO = MgRnrCardInfoConverter.INSTANCE.dtoToPo(cardDTO);
            cardPOList.add(cardInfoPO);
            MgRnrOperationLogPO rnrOptLog = new MgRnrOperationLogPO();
            rnrOptLog.setUuid(CuscStringUtils.generateUuid());
            rnrOptLog.setBizType(Integer.valueOf(RnrOptLogBizTypeEnum.CARD.getCode()));
            rnrOptLog.setBizUuid(cardDTO.getUuid());
            rnrOptLog.setOptType(RnrOptLogOptTypeEnum.OPERATE_RNR.getCode());
            rnrOptLog.setOptSubType(RnrOptLogSubTypeEnum.CREATE_OPERATE.getCode());
            rnrOptLog.setOptTime(new Date());
            rnrOptLog.setContent(logComment);
            rnrOptLog.setIsBatchOrder(order.getIsBatchOrder());
            rnrOptLog.setSource(order.getOrderSource());
            rnrOptLog.setSerialNumber(order.getSerialNumber());
            rnrOptLog.setCreator(info.getCreator());
            rnrOptLog.setTenantNo(order.getTenantNo());
            cardLogList.add(rnrOptLog);
        }
        this.rnrCardInfoService.addRnrCardBatch(cardPOList);
        this.rnrOrderService.insertOrder(order);
        this.mqSendService.sendBindUnbindExchangeMq(order.getUuid());
        this.rnrOperationLogService.addRnrOperationLogPOBatch(cardLogList);
        return order.getUuid();
    }

    @Transactional(rollbackFor={Throwable.class})
    public void surplusConfirm(SurplusConfirmDto confirmDto) {
        RnrOrderDTO rnrOrderDTO = new RnrOrderDTO();
        rnrOrderDTO.setUuid(confirmDto.getOrderId());
        rnrOrderDTO = this.rnrOrderService.getByUuid(rnrOrderDTO);
        if (rnrOrderDTO == null) {
            throw new CuscUserException("", "\u672a\u67e5\u8be2\u5230\u5de5\u5355\u4fe1\u606f:" + confirmDto.getOrderId());
        }
        if (!RnrOrderStatusEnum.notFinished((Integer)rnrOrderDTO.getOrderStatus())) {
            return;
        }
        int rnrStatus = RnrStatus.RNR_FAIL.getCode();
        int orderStatus = RnrOrderStatusEnum.CANCEL.getCode();
        int noticeStatus = NoticeStatusEnum.NONEED.getCode();
        if (confirmDto.getCallbackStatusEnum() == MessageCallbackStatusEnum.Y.getCode()) {
            rnrStatus = RnrStatus.RNR.getCode();
            orderStatus = RnrOrderStatusEnum.PASS.getCode();
            noticeStatus = NoticeStatusEnum.NEED.getCode();
        } else if (confirmDto.getCallbackStatusEnum() == MessageCallbackStatusEnum.N.getCode()) {
            rnrStatus = RnrStatus.RNR_FAIL.getCode();
            orderStatus = RnrOrderStatusEnum.NOT_PASS.getCode();
            noticeStatus = NoticeStatusEnum.NONEED.getCode();
        }
        ArrayList<MgCardNoticeDTO> mqList = new ArrayList<MgCardNoticeDTO>();
        if (confirmDto.getCallbackStatusEnum() == MessageCallbackStatusEnum.Y.getCode()) {
            MgRnrCardInfoDTO cardInfoDTO = new MgRnrCardInfoDTO();
            cardInfoDTO.setOrderId(confirmDto.getOrderId());
            List mgRnrCardInfoDTOS = this.rnrCardInfoService.queryByList(cardInfoDTO);
            for (MgRnrCardInfoDTO cardDTO : mgRnrCardInfoDTOS) {
                MgCardNoticeDTO mqDTO = new MgCardNoticeDTO();
                mqDTO.setVin(cardDTO.getIotId());
                mqDTO.setRnrBizzType(RnrBizzTypeEnum.Bind.getCode().intValue());
                mqDTO.setOrderId(cardDTO.getOrderId());
                mqDTO.setIccid(cardDTO.getIccid());
                mqList.add(mqDTO);
            }
            this.notifyCloudService.notifyResult(mgRnrCardInfoDTOS, RnrBizzTypeEnum.Bind.getCode().toString(), UUID.randomUUID().toString(), null, RnrOrderStatusEnum.PASS.getCode().toString());
        }
        this.rnrCardInfoService.updateCardStatusByOrderId(confirmDto.getOrderId(), noticeStatus, rnrStatus);
        this.rnrOrderService.updateOrderStatus(Collections.singletonList(confirmDto.getOrderId()), orderStatus);
        if (!CollectionUtils.isEmpty(mqList)) {
            this.cardNoticeService.sendCardNotice(mqList);
        }
    }
}

