/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.converter.MgSecretKeyConverter;
import com.cusc.nirvana.user.rnr.mg.dao.MgSecretKeyDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgSecretKeyPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgSecretKeyDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgSecretKeyService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MgSecretKeyServiceImpl
extends ServiceImpl<MgSecretKeyDao, MgSecretKeyPO>
implements IMgSecretKeyService {
    private static final Logger log = LoggerFactory.getLogger(MgSecretKeyServiceImpl.class);
    @Autowired
    private CacheFactory cacheFactory;

    public MgSecretKeyDTO getByUuid(MgSecretKeyDTO bean) {
        MgSecretKeyPO record = this.getPoByUuid(bean.getUuid());
        return MgSecretKeyConverter.INSTANCE.poToDto(record);
    }

    public List<MgSecretKeyDTO> queryByList(MgSecretKeyDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getOrgId()), (Object)"org_id", (Object)bean.getOrgId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getOpenApiKey()), (Object)"open_api_key", (Object)bean.getOpenApiKey());
        List record = this.list((Wrapper)queryWrapper);
        return MgSecretKeyConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<MgSecretKeyDTO> queryByPage(MgSecretKeyDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, MgSecretKeyDTO.class);
    }

    @Transactional
    public MgSecretKeyDTO insert(MgSecretKeyDTO bean) {
        MgSecretKeyPO mgSecretKeyPO = MgSecretKeyConverter.INSTANCE.dtoToPo(bean);
        mgSecretKeyPO.setUuid(CuscStringUtils.generateUuid());
        mgSecretKeyPO.setOpenApiKey(bean.getOpenApiKey());
        this.save((Object)mgSecretKeyPO);
        bean.setUuid(mgSecretKeyPO.getUuid());
        return bean;
    }

    @Transactional
    public MgSecretKeyDTO update(MgSecretKeyDTO bean) {
        MgSecretKeyPO mgSecretKeyPO = this.getPoByUuid(bean.getUuid());
        if (mgSecretKeyPO == null) {
            return null;
        }
        MgSecretKeyPO tmpBean = MgSecretKeyConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(mgSecretKeyPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(MgSecretKeyDTO bean) {
        MgSecretKeyPO mgSecretKeyPO = this.getPoByUuid(bean.getUuid());
        if (mgSecretKeyPO == null) {
            return false;
        }
        MgSecretKeyPO tmpBean = new MgSecretKeyPO();
        tmpBean.setId(mgSecretKeyPO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    public MgSecretKeyDTO getByTenantNoAndOrgan(MgSecretKeyDTO bean) {
        MgSecretKeyDTO ret = null;
        String orgId = bean.getOrgId();
        if (CuscStringUtils.isEmpty((String)bean.getOrgId())) {
            orgId = "0";
        }
        try {
            ret = (MgSecretKeyDTO)this.cacheFactory.getExpireStringService().getValue("CT:RNR:SECRET_KEY:" + bean.getTenantNo() + ":" + orgId, MgSecretKeyDTO.class);
            if (ret == null) {
                List secretKeyDTOList = this.queryByList(bean);
                if (CollectionUtils.isEmpty((Collection)secretKeyDTOList)) {
                    return null;
                }
                ret = (MgSecretKeyDTO)secretKeyDTOList.get(0);
                this.cacheFactory.getExpireStringService().setExpireValue("CT:RNR:SECRET_KEY:" + bean.getTenantNo() + ":" + orgId, (Object)ret, 28800);
            }
        }
        catch (CacheException e) {
            log.error("getByTenantNoAndOrgan redis error : ", (Throwable)e);
        }
        return ret;
    }

    private MgSecretKeyPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgSecretKeyPO)this.getOne((Wrapper)queryWrapper);
    }
}

