/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrTagConverter;
import com.cusc.nirvana.user.rnr.mg.dao.MgRnrTagDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrTagPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrTagDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrTagService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MgRnrTagServiceImpl
extends ServiceImpl<MgRnrTagDao, MgRnrTagPO>
implements IMgRnrTagService {
    public MgRnrTagDTO getByUuid(MgRnrTagDTO bean) {
        MgRnrTagPO record = this.getPoByUuid(bean.getUuid());
        return MgRnrTagConverter.INSTANCE.poToDto(record);
    }

    public List<MgRnrTagDTO> queryByList(MgRnrTagDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrTagConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<MgRnrTagDTO> queryByPage(MgRnrTagDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, MgRnrTagDTO.class);
    }

    @Transactional
    public MgRnrTagDTO insert(MgRnrTagDTO bean) {
        MgRnrTagPO MgRnrTagPO2 = MgRnrTagConverter.INSTANCE.dtoToPo(bean);
        MgRnrTagPO2.setUuid(CuscStringUtils.generateUuid());
        this.save((Object)MgRnrTagPO2);
        bean.setUuid(MgRnrTagPO2.getUuid());
        return bean;
    }

    @Transactional
    public MgRnrTagDTO update(MgRnrTagDTO bean) {
        MgRnrTagPO MgRnrTagPO2 = this.getPoByUuid(bean.getUuid());
        if (MgRnrTagPO2 == null) {
            return null;
        }
        MgRnrTagPO tmpBean = MgRnrTagConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(MgRnrTagPO2.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(MgRnrTagDTO bean) {
        MgRnrTagPO MgRnrTagPO2 = this.getPoByUuid(bean.getUuid());
        if (MgRnrTagPO2 == null) {
            return false;
        }
        MgRnrTagPO tmpBean = new MgRnrTagPO();
        tmpBean.setId(MgRnrTagPO2.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    public Integer addRnrTagBatch(List<MgRnrTagPO> beanList) {
        return ((MgRnrTagDao)this.baseMapper).addRnrTagBatch(beanList);
    }

    public Integer addRnrTagFromRnrInfo(MgRnrInfoDTO info, List<MgRnrTagDTO> beanList) {
        ArrayList<MgRnrTagPO> tagPOList = new ArrayList<MgRnrTagPO>();
        for (MgRnrTagDTO tagDTO : beanList) {
            tagDTO.setUuid(CuscStringUtils.generateUuid());
            tagDTO.setRnrId(info.getUuid());
            tagDTO.setTenantNo(info.getTenantNo());
            tagDTO.setRoutingKey(info.getRoutingKey());
            MgRnrTagPO tagPO = MgRnrTagConverter.INSTANCE.dtoToPo(tagDTO);
            tagPOList.add(tagPO);
        }
        return this.addRnrTagBatch(tagPOList);
    }

    private MgRnrTagPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgRnrTagPO)this.getOne((Wrapper)queryWrapper);
    }
}

