/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrOperationLogConverter;
import com.cusc.nirvana.user.rnr.mg.dao.MgRnrOperationLogDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrOperationLogPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrOperationLogDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrOperationLogService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MgRnrOperationLogServiceImpl
extends ServiceImpl<MgRnrOperationLogDao, MgRnrOperationLogPO>
implements IMgRnrOperationLogService {
    private static final Logger log = LoggerFactory.getLogger(MgRnrOperationLogServiceImpl.class);

    public MgRnrOperationLogDTO getByUuid(MgRnrOperationLogDTO bean) {
        MgRnrOperationLogPO record = this.getPoByUuid(bean.getUuid());
        return MgRnrOperationLogConverter.INSTANCE.poToDto(record);
    }

    public List<MgRnrOperationLogDTO> queryByList(MgRnrOperationLogDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrOperationLogConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<MgRnrOperationLogDTO> queryByPage(MgRnrOperationLogDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, MgRnrOperationLogDTO.class);
    }

    @Transactional
    public MgRnrOperationLogDTO insert(MgRnrOperationLogDTO bean) {
        MgRnrOperationLogPO mgRnrOperationLogPO = MgRnrOperationLogConverter.INSTANCE.dtoToPo(bean);
        mgRnrOperationLogPO.setUuid(CuscStringUtils.generateUuid());
        this.save((Object)mgRnrOperationLogPO);
        bean.setUuid(mgRnrOperationLogPO.getUuid());
        return bean;
    }

    @Transactional
    public MgRnrOperationLogDTO update(MgRnrOperationLogDTO bean) {
        MgRnrOperationLogPO mgRnrOperationLogPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrOperationLogPO == null) {
            return null;
        }
        MgRnrOperationLogPO tmpBean = MgRnrOperationLogConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(mgRnrOperationLogPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Async(value="logToDBExecutor")
    public void addRnrOperationLogBatch(List<MgRnrOperationLogDTO> beanList) {
        log.info("addRnrOperationLogBatch paramter: {}", beanList);
        ((MgRnrOperationLogDao)this.baseMapper).addRnrOperationLogBatch(MgRnrOperationLogConverter.INSTANCE.dtoListToPoList(beanList));
    }

    @Async(value="logToDBExecutor")
    public void addRnrOperationLogPOBatch(List<MgRnrOperationLogPO> beanList) {
        log.info("addRnrOperationLogPOBatch paramter: {}", beanList);
        ((MgRnrOperationLogDao)this.baseMapper).addRnrOperationLogBatch(beanList);
    }

    private MgRnrOperationLogPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgRnrOperationLogPO)this.getOne((Wrapper)queryWrapper);
    }
}

