/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrLiaisonInfoConverter;
import com.cusc.nirvana.user.rnr.mg.dao.MgRnrLiaisonInfoDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrLiaisonInfoPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrLiaisonInfoDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrLiaisonInfoService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MgRnrLiaisonInfoServiceImpl
extends ServiceImpl<MgRnrLiaisonInfoDao, MgRnrLiaisonInfoPO>
implements IMgRnrLiaisonInfoService {
    public MgRnrLiaisonInfoDTO getByUuid(MgRnrLiaisonInfoDTO bean) {
        MgRnrLiaisonInfoPO record = this.getPoByUuid(bean.getUuid());
        return MgRnrLiaisonInfoConverter.INSTANCE.poToDto(record);
    }

    public MgRnrLiaisonInfoDTO getByRnrid(MgRnrLiaisonInfoDTO bean) {
        MgRnrLiaisonInfoPO record = this.getPoByRnrid(bean.getRnrId());
        return MgRnrLiaisonInfoConverter.INSTANCE.poToDto(record);
    }

    public List<MgRnrLiaisonInfoDTO> queryByList(MgRnrLiaisonInfoDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getRnrId()), (Object)"rnr_id", (Object)bean.getRnrId());
        queryWrapper.eq(bean.getRnrBizzType() != null, (Object)"rnr_bizz_type", (Object)bean.getRnrBizzType());
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrLiaisonInfoConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<MgRnrLiaisonInfoDTO> queryByPage(MgRnrLiaisonInfoDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, MgRnrLiaisonInfoDTO.class);
    }

    @Transactional
    public MgRnrLiaisonInfoDTO insert(MgRnrLiaisonInfoDTO bean) {
        MgRnrLiaisonInfoPO mgRnrLiaisonInfoPO = MgRnrLiaisonInfoConverter.INSTANCE.dtoToPo(bean);
        mgRnrLiaisonInfoPO.setUuid(CuscStringUtils.generateUuid());
        this.save((Object)mgRnrLiaisonInfoPO);
        bean.setUuid(mgRnrLiaisonInfoPO.getUuid());
        return bean;
    }

    @Transactional
    public MgRnrLiaisonInfoDTO update(MgRnrLiaisonInfoDTO bean) {
        MgRnrLiaisonInfoPO mgRnrLiaisonInfoPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrLiaisonInfoPO == null) {
            return null;
        }
        MgRnrLiaisonInfoPO tmpBean = MgRnrLiaisonInfoConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(mgRnrLiaisonInfoPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(MgRnrLiaisonInfoDTO bean) {
        MgRnrLiaisonInfoPO mgRnrLiaisonInfoPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrLiaisonInfoPO == null) {
            return false;
        }
        MgRnrLiaisonInfoPO tmpBean = new MgRnrLiaisonInfoPO();
        tmpBean.setId(mgRnrLiaisonInfoPO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    public Integer addRnrLiaisonBatch(List<MgRnrLiaisonInfoPO> beanList) {
        return ((MgRnrLiaisonInfoDao)this.baseMapper).addRnrLiaisonBatch(beanList);
    }

    public Integer addRnrLiaisonFromRnrInfo(MgRnrInfoDTO info, List<MgRnrLiaisonInfoDTO> beanList) {
        for (MgRnrLiaisonInfoDTO liaisonDTO : beanList) {
            liaisonDTO.setRnrId(info.getUuid());
            liaisonDTO.setTenantNo(info.getTenantNo());
            liaisonDTO.setRoutingKey(info.getRoutingKey());
            MgRnrLiaisonInfoPO liaisonPO = MgRnrLiaisonInfoConverter.INSTANCE.dtoToPo(liaisonDTO);
            ((MgRnrLiaisonInfoDao)this.baseMapper).insert((Object)liaisonPO);
        }
        return beanList.size();
    }

    private MgRnrLiaisonInfoPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgRnrLiaisonInfoPO)this.getOne((Wrapper)queryWrapper);
    }

    public MgRnrLiaisonInfoPO getPoByRnrid(String rnrid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"rnr_id", (Object)rnrid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgRnrLiaisonInfoPO)this.getOne((Wrapper)queryWrapper);
    }
}

