/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.constants.CryptKeyHelper;
import com.cusc.nirvana.user.rnr.mg.constants.RnrStatus;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrInfoConverter;
import com.cusc.nirvana.user.rnr.mg.dao.MgRnrInfoDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrInfoPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrInfoService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MgRnrInfoServiceImpl
extends ServiceImpl<MgRnrInfoDao, MgRnrInfoPO>
implements IMgRnrInfoService {
    public MgRnrInfoDTO getByUuid(MgRnrInfoDTO bean) {
        MgRnrInfoPO record = this.getPoByUuid(bean.getUuid());
        return MgRnrInfoConverter.INSTANCE.poToDto(record);
    }

    public List<MgRnrInfoDTO> queryByList(MgRnrInfoDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.in(!CollectionUtils.isEmpty((Collection)bean.getUuidList()), (Object)"uuid", (Collection)bean.getUuidList());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getTenantNo()), (Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getFullName()), (Object)"full_name", (Object)CryptKeyHelper.encrypt((String)bean.getFullName()));
        queryWrapper.eq(null != bean.getRnrStatus(), (Object)"rnr_status", (Object)bean.getRnrStatus());
        queryWrapper.exists(StringUtils.isNotBlank((CharSequence)bean.getCompanyName()), "select 1 from mg_rnr_company_info company where mg_rnr_info.uuid = company.rnr_id and company.company_name = '" + CryptKeyHelper.encrypt((String)bean.getCompanyName()) + "'");
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrInfoConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<MgRnrInfoDTO> queryByPage(MgRnrInfoDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, MgRnrInfoDTO.class);
    }

    @Transactional
    public MgRnrInfoDTO insert(MgRnrInfoDTO bean) {
        MgRnrInfoPO mgRnrInfoPO = MgRnrInfoConverter.INSTANCE.dtoToPo(bean);
        if (CuscStringUtils.isEmpty((String)bean.getUuid())) {
            mgRnrInfoPO.setUuid(CuscStringUtils.generateUuid());
            bean.setUuid(mgRnrInfoPO.getUuid());
        }
        this.save((Object)mgRnrInfoPO);
        return bean;
    }

    @Transactional
    public MgRnrInfoDTO update(MgRnrInfoDTO bean) {
        MgRnrInfoPO mgRnrInfoPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrInfoPO == null) {
            return null;
        }
        MgRnrInfoPO tmpBean = MgRnrInfoConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(mgRnrInfoPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(MgRnrInfoDTO bean) {
        MgRnrInfoPO mgRnrInfoPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrInfoPO == null) {
            return false;
        }
        MgRnrInfoPO tmpBean = new MgRnrInfoPO();
        tmpBean.setId(mgRnrInfoPO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    public void updateRnrStatus(String rnrId, RnrStatus status) {
        ((MgRnrInfoDao)this.baseMapper).updateRnrStatus(rnrId, status.getCode());
    }

    public void updateRnrStatusBatch(List<String> rnrIds, RnrStatus status) {
        ((MgRnrInfoDao)this.baseMapper).updateRnrStatusBatch(rnrIds, status.getCode());
    }

    public MgRnrInfoPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgRnrInfoPO)this.getOne((Wrapper)queryWrapper);
    }
}

