/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrImageConverter;
import com.cusc.nirvana.user.rnr.mg.dao.MgRnrFileDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrFilePO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrFileDTO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrInfoDTO;
import com.cusc.nirvana.user.rnr.mg.service.IFileService;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrFileService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MgRnrFileServiceImpl
extends ServiceImpl<MgRnrFileDao, MgRnrFilePO>
implements IMgRnrFileService {
    @Autowired
    private IFileService fileService;

    public MgRnrFileDTO getByUuid(MgRnrFileDTO bean) {
        MgRnrFilePO record = this.getPoByUuid(bean.getUuid());
        return MgRnrImageConverter.INSTANCE.poToDto(record);
    }

    public List<MgRnrFileDTO> getByRnrid(MgRnrFileDTO bean) {
        List poByRnrid = this.getPoByRnrid(bean.getRnrId(), bean.getTenantNo());
        return MgRnrImageConverter.INSTANCE.poListToDtoList(poByRnrid);
    }

    public List<MgRnrFileDTO> queryByList(MgRnrFileDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getRnrId()), (Object)"rnr_id", (Object)bean.getRnrId());
        queryWrapper.eq(bean.getRnrBizzType() != null, (Object)"rnr_bizz_type", (Object)bean.getRnrBizzType());
        queryWrapper.eq(bean.getFileType() != null, (Object)"file_type", (Object)bean.getFileType());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getRnrCompanyId()), (Object)"rnr_company_id", (Object)bean.getRnrCompanyId());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getLiaisonId()), (Object)"liaison_id", (Object)bean.getLiaisonId());
        queryWrapper.eq(bean.getRoutingKey() != null, (Object)"routing_key", (Object)bean.getRoutingKey());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getTenantNo()), (Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc(new Object[]{"order_no", "create_time"});
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrImageConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<MgRnrFileDTO> queryByPage(MgRnrFileDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, MgRnrFileDTO.class);
    }

    @Transactional
    public MgRnrFileDTO insert(MgRnrFileDTO bean) {
        MgRnrFilePO mgRnrImagePO = MgRnrImageConverter.INSTANCE.dtoToPo(bean);
        if (CuscStringUtils.isEmpty((String)bean.getUuid())) {
            mgRnrImagePO.setUuid(CuscStringUtils.generateUuid());
            bean.setUuid(mgRnrImagePO.getUuid());
        }
        this.save((Object)mgRnrImagePO);
        return bean;
    }

    @Transactional
    public MgRnrFileDTO update(MgRnrFileDTO bean) {
        MgRnrFilePO MgRnrImagePO = this.getPoByUuid(bean.getUuid());
        if (MgRnrImagePO == null) {
            return null;
        }
        MgRnrFilePO tmpBean = MgRnrImageConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(MgRnrImagePO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(MgRnrFileDTO bean) {
        MgRnrFilePO MgRnrImagePO = this.getPoByUuid(bean.getUuid());
        if (MgRnrImagePO == null) {
            return false;
        }
        MgRnrFilePO tmpBean = new MgRnrFilePO();
        tmpBean.setId(MgRnrImagePO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    public List<MgRnrFileDTO> rnrImageBatchUpload(List<MgRnrFileDTO> imageList, MgRnrInfoDTO rnrInfoDTO) {
        return null;
    }

    public Integer addRnrFileBatch(List<MgRnrFilePO> beanList) {
        return ((MgRnrFileDao)this.baseMapper).addRnrFileBatch(beanList);
    }

    public Integer addRnrFileFromInfo(MgRnrInfoDTO info, List<MgRnrFileDTO> beanList) {
        if (CollectionUtils.isEmpty(beanList)) {
            return 0;
        }
        ArrayList<MgRnrFilePO> imagePOList = new ArrayList<MgRnrFilePO>();
        for (MgRnrFileDTO imageDTO : beanList) {
            imageDTO.setUuid(CuscStringUtils.generateUuid());
            imageDTO.setFileSystemId(imageDTO.getFileSystemId());
            imageDTO.setRnrId(info.getUuid());
            imageDTO.setTenantNo(info.getTenantNo());
            imageDTO.setRoutingKey(info.getRoutingKey());
            imageDTO.setRnrBizzType(info.getRnrBizzType());
            imageDTO.setIsCompany(info.getIsCompany());
            MgRnrFilePO imagePO = MgRnrImageConverter.INSTANCE.dtoToPo(imageDTO);
            imagePOList.add(imagePO);
        }
        return this.addRnrFileBatch(imagePOList);
    }

    private MgRnrFilePO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgRnrFilePO)this.getOne((Wrapper)queryWrapper);
    }

    public List<MgRnrFilePO> getPoByRnrid(String rnrid, String tenantNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"rnr_id", (Object)rnrid);
        queryWrapper.eq((Object)"tenant_no", (Object)tenantNo);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    public List<MgRnrFilePO> getPoByRnridOrderByOrderno(String rnrid, String tenantNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"rnr_id", (Object)rnrid);
        queryWrapper.eq((Object)"tenant_no", (Object)tenantNo);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByAsc((Object)"order_no");
        return this.list((Wrapper)queryWrapper);
    }
}

