/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.mg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.user.rnr.mg.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.rnr.mg.constants.CryptKeyHelper;
import com.cusc.nirvana.user.rnr.mg.converter.MgRnrCompanyInfoConverter;
import com.cusc.nirvana.user.rnr.mg.dao.MgRnrCompanyInfoDao;
import com.cusc.nirvana.user.rnr.mg.dao.entity.MgRnrCompanyInfoPO;
import com.cusc.nirvana.user.rnr.mg.dto.MgRnrCompanyInfoDTO;
import com.cusc.nirvana.user.rnr.mg.service.IMgRnrCompanyInfoService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MgRnrCompanyInfoServiceImpl
extends ServiceImpl<MgRnrCompanyInfoDao, MgRnrCompanyInfoPO>
implements IMgRnrCompanyInfoService {
    public MgRnrCompanyInfoDTO getByUuid(MgRnrCompanyInfoDTO bean) {
        MgRnrCompanyInfoPO record = this.getPoByUuid(bean.getUuid());
        return MgRnrCompanyInfoConverter.INSTANCE.poToDto(record);
    }

    public MgRnrCompanyInfoDTO getByRnrid(MgRnrCompanyInfoDTO bean) {
        MgRnrCompanyInfoPO record = this.getPoByRnrid(bean.getRnrId());
        return MgRnrCompanyInfoConverter.INSTANCE.poToDto(record);
    }

    public List<String> findRnrIdsByCompanyName(MgRnrCompanyInfoDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"company_name", (Object)CryptKeyHelper.encrypt((String)bean.getCompanyName()));
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return record.stream().map(info -> info.getRnrId()).collect(Collectors.toList());
    }

    public List<MgRnrCompanyInfoDTO> queryByList(MgRnrCompanyInfoDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getTenantNo()), (Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq(null != bean.getIsVehicleCompany(), (Object)"is_vehicle_company", (Object)bean.getIsVehicleCompany());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bean.getRnrId()), (Object)"rnr_id", (Object)bean.getRnrId());
        queryWrapper.likeLeft(StringUtils.isNotBlank((CharSequence)bean.getCompanyName()), (Object)"company_name", (Object)CryptKeyHelper.encrypt((String)bean.getCompanyName()));
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return MgRnrCompanyInfoConverter.INSTANCE.poListToDtoList(record);
    }

    @Transactional
    public MgRnrCompanyInfoDTO insert(MgRnrCompanyInfoDTO bean) {
        MgRnrCompanyInfoPO mgRnrCompanyInfoPO = MgRnrCompanyInfoConverter.INSTANCE.dtoToPo(bean);
        if (CuscStringUtils.isEmpty((String)bean.getUuid())) {
            mgRnrCompanyInfoPO.setUuid(CuscStringUtils.generateUuid());
            bean.setUuid(mgRnrCompanyInfoPO.getUuid());
        }
        this.save((Object)mgRnrCompanyInfoPO);
        return bean;
    }

    @Transactional
    public MgRnrCompanyInfoDTO update(MgRnrCompanyInfoDTO bean) {
        MgRnrCompanyInfoPO mgRnrCompanyInfoPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrCompanyInfoPO == null) {
            return null;
        }
        MgRnrCompanyInfoPO tmpBean = MgRnrCompanyInfoConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(mgRnrCompanyInfoPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(MgRnrCompanyInfoDTO bean) {
        MgRnrCompanyInfoPO mgRnrCompanyInfoPO = this.getPoByUuid(bean.getUuid());
        if (mgRnrCompanyInfoPO == null) {
            return false;
        }
        MgRnrCompanyInfoPO tmpBean = new MgRnrCompanyInfoPO();
        tmpBean.setId(mgRnrCompanyInfoPO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    private MgRnrCompanyInfoPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgRnrCompanyInfoPO)this.getOne((Wrapper)queryWrapper);
    }

    private MgRnrCompanyInfoPO getPoByRnrid(String rnrid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"rnr_id", (Object)rnrid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (MgRnrCompanyInfoPO)this.getOne((Wrapper)queryWrapper);
    }
}

